/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import play.core.enhancers.PropertiesEnhancer;
import utils.JSInvocable;
import utils.MomentUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JodaDateUtil {
    public static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";

    public static String getDateString(Date date) {
        return JodaDateUtil.getDateString(date, null);
    }

    public static String getDateString(Date date, String format) {
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = "yyyy-MM-dd h:mm:ss a";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date == null) {
            return "";
        }
        return sdf.format(date);
    }

    public static Date today() {
        return LocalDate.now().toDate();
    }

    public static Date now() {
        return DateTime.now().toDate();
    }

    public static Duration ago(DateTime time) {
        return new Duration((ReadableInstant)time, (ReadableInstant)DateTime.now());
    }

    public static Duration ago(Date time) {
        return new Duration((ReadableInstant)new DateTime((Object)time), (ReadableInstant)DateTime.now());
    }

    public static Duration ago(Long time) {
        return new Duration((ReadableInstant)new DateTime((Object)new Date(time)), (ReadableInstant)DateTime.now());
    }

    public static Date before(int days) {
        return new DateTime((Object)JodaDateUtil.today()).minusDays(days).toDate();
    }

    public static Date beforeByMillis(long millis) {
        return new DateTime((Object)JodaDateUtil.today()).minus(millis).toDate();
    }

    public static String momentFromNow(Long time) {
        return JodaDateUtil.momentFromNow(time, "en");
    }

    public static String momentFromNow(Long time, String language) {
        JSInvocable moment = MomentUtil.newMoment(time, language);
        return moment.invoke("fromNow", new Object[0]);
    }

    public static String momentFromNow(Date time) {
        return JodaDateUtil.momentFromNow(time, "en");
    }

    public static String momentFromNow(Date time, String language) {
        JSInvocable moment = MomentUtil.newMoment(time.getTime(), language);
        return moment.invoke("fromNow", new Object[0]);
    }

    public static int localDaysBetween(Date from, Date to) {
        return Days.daysBetween((ReadablePartial)new DateTime((Object)from).toLocalDate(), (ReadablePartial)new DateTime((Object)to).toLocalDate()).getDays();
    }

    public static Date lastSecondOfDay(Date date) {
        if (date == null) {
            return null;
        }
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.withField(DateTimeFieldType.hourOfDay(), 23).withField(DateTimeFieldType.minuteOfHour(), 59).withField(DateTimeFieldType.secondOfMinute(), 59).toDate();
    }

    public static String socialDate(Date date) {
        if (date == null) {
            return "";
        }
        DateTime dateTime = new DateTime((Object)date);
        boolean isBeforeYesterday = dateTime.isBefore((ReadableInstant)DateTime.now().minusDays(1));
        if (isBeforeYesterday) {
            return dateTime.toString("yyyy-MM-dd h:mm a", Locale.getDefault());
        }
        return JodaDateUtil.momentFromNow(date, Locale.getDefault().getLanguage());
    }

    public static String getDateStringWithoutSpace(Date date) {
        if (date == null) {
            date = new Date();
        }
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toString("yyyyMMddHHmm", Locale.getDefault());
    }

    public static String geYMDDate(Date date) {
        if (date == null) {
            return "";
        }
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toString("yyyy-MM-dd", Locale.getDefault());
    }

    public static String getOptionalShortDate(Date date) {
        if (date == null) {
            return "";
        }
        DateTime targetTime = new DateTime((Object)date);
        DateTime currentTime = new DateTime((Object)new Date());
        if (JodaDateUtil.isSameYear(targetTime, currentTime)) {
            if (JodaDateUtil.isSameDay(targetTime, currentTime)) {
                return targetTime.toString("'at' h:mm a", Locale.getDefault());
            }
            return targetTime.toString("MMM d 'at' h:mm a", Locale.getDefault());
        }
        return targetTime.toString("YY.MM.dd 'at' h:mm a", Locale.getDefault());
    }

    private static boolean isSameYear(DateTime targetTime, DateTime currentTime) {
        return currentTime.toString("YYYY").equals(targetTime.toString("YYYY"));
    }

    private static boolean isSameDay(DateTime targetTime, DateTime currentTime) {
        return currentTime.toString("YYYYMMdd").equals(targetTime.toString("YYYYMMdd"));
    }
}

