/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Lang;
import play.mvc.Http;
import utils.FastHttpDateFormat;
import utils.PlayServletContext;
import utils.PlayServletSession;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PlayServletRequest
implements HttpServletRequest {
    private String characterEncoding;
    private final Http.Request request;
    Map<String, Object> attributes = new HashMap<String, Object>();
    private final HttpSession httpSession;
    private String username;
    protected final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private final String pathInfo;

    public PlayServletRequest(Http.Request request, String authenticatedUsername, String pathInfo) {
        this.request = request;
        this.httpSession = new PlayServletSession(new PlayServletContext());
        this.pathInfo = SVNEncodingUtil.uriEncode((String)pathInfo);
        this.username = authenticatedUsername;
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        String contentLength = this.request.getHeader("Content-Length");
        if (contentLength == null) {
            return -1;
        }
        return Integer.parseInt(contentLength);
    }

    public long getContentLengthLong() {
        String contentLength = this.request.getHeader("Content-Length");
        if (contentLength == null) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    public String getContentType() {
        return this.request.getHeader("Content-Type");
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public ServletInputStream getInputStream() throws IOException {
        InputStream in;
        byte[] buf;
        Http.RawBuffer raw = this.request.body().asRaw();
        try {
            buf = raw.asBytes();
        }
        catch (NullPointerException e) {
            throw new IOException("Request entity is too large.", e);
        }
        if (buf != null) {
            in = new ByteArrayInputStream(buf);
        } else {
            File file = raw.asFile();
            if (file == null) {
                throw new IOException("Request entity is too large.");
            }
            in = new BufferedInputStream(new FileInputStream(file));
        }
        return new ServletInputStream(){

            public int read() throws IOException {
                return in.read();
            }

            public void close() throws IOException {
                in.close();
                super.close();
            }

            protected void finalize() throws Throwable {
                this.close();
                super.finalize();
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException();
            }

            public boolean isReady() {
                throw new UnsupportedOperationException();
            }

            public boolean isFinished() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        List languages = this.request.acceptLanguages();
        if (languages.size() > 0) {
            return ((Lang)languages.get(0)).toLocale();
        }
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (Lang lang : this.request.acceptLanguages()) {
            locales.add(lang.toLocale());
        }
        return Collections.enumeration(locales);
    }

    public String getParameter(String key) {
        String[] values = (String[])this.request.queryString().get(key);
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.queryString();
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.request.queryString().keySet());
    }

    public String[] getParameterValues(String key) {
        return (String[])this.request.queryString().get(key);
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getRealPath(String path) {
        return Play.application().getFile(path).getAbsolutePath();
    }

    public String getRemoteAddr() {
        return this.request.remoteAddress();
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        String scheme = null;
        try {
            scheme = new URI(this.request.uri()).getScheme();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (scheme == null) {
            return "http";
        }
        return scheme;
    }

    public String getServerName() {
        return this.request.host().split(":")[0];
    }

    public int getServerPort() {
        try {
            return Integer.parseInt(this.request.host().split(":")[1]);
        }
        catch (Exception e) {
            if (this.getScheme().equals("https")) {
                return 443;
            }
            return 80;
        }
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public boolean isSecure() {
        return this.getScheme().equals("https");
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException();
    }

    public long getDateHeader(String name) {
        String date = this.request.getHeader(name);
        if (date == null) {
            return -1L;
        }
        return FastHttpDateFormat.parseDate(this.request.getHeader(name), this.formats);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.request.headers().keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        String[] values = (String[])this.request.headers().get(name);
        if (values == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return Collections.enumeration(Arrays.asList((Object[])this.request.headers().get(name)));
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.request.method();
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        String uri = this.request.uri();
        int index2 = uri.indexOf(63);
        if (index2 >= 0) {
            return uri.substring(index2 + 1);
        }
        return null;
    }

    public String getRemoteUser() {
        return this.username;
    }

    public String getRequestURI() {
        return this.request.path();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.request.uri());
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getServletPath() {
        String path = this.request.path();
        return path.substring(0, path.length() - this.pathInfo.length());
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public HttpSession getSession(boolean create2) {
        return this.httpSession;
    }

    public Principal getUserPrincipal() {
        return new Principal(){

            @Override
            public String getName() {
                return PlayServletRequest.this.username;
            }
        };
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }
}

