/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.config.dbplatform.SqlLimitRequest;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebean.config.dbplatform.SqlLimiter;

public class LimitOffsetSqlLimiter
implements SqlLimiter {
    private static final String LIMIT = "limit";
    private static final String OFFSET = "offset";

    @Override
    public SqlLimitResponse limit(SqlLimitRequest request) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("select ");
        if (request.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(request.getDbSql());
        int firstRow = request.getFirstRow();
        int maxRows = request.getMaxRows();
        if (maxRows > 0) {
            ++maxRows;
        }
        if (maxRows > 0 || firstRow > 0) {
            sb.append(" ").append('\n').append(LIMIT).append(" ").append(maxRows);
            if (firstRow > 0) {
                sb.append(" ").append(OFFSET).append(" ");
                sb.append(firstRow);
            }
        }
        String sql = request.getDbPlatform().completeSql(sb.toString(), request.getOrmQuery());
        return new SqlLimitResponse(sql, false);
    }
}

