/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.server.lib.DaemonScheduleThreadPool;
import com.avaje.ebeaninternal.server.lib.DaemonThreadPool;
import java.util.concurrent.TimeUnit;

public class DefaultBackgroundExecutor
implements SpiBackgroundExecutor {
    private final DaemonThreadPool pool;
    private final DaemonScheduleThreadPool schedulePool;

    public DefaultBackgroundExecutor(int schedulePoolSize, int corePoolSize, long keepAliveSecs, int shutdownWaitSeconds, String namePrefix) {
        this.pool = new DaemonThreadPool(corePoolSize, keepAliveSecs, shutdownWaitSeconds, namePrefix);
        this.schedulePool = new DaemonScheduleThreadPool(schedulePoolSize, shutdownWaitSeconds, namePrefix + "-periodic-");
    }

    @Override
    public void execute(Runnable r) {
        this.pool.execute(r);
    }

    @Override
    public void executePeriodically(Runnable r, long delay, TimeUnit unit) {
        this.schedulePool.scheduleWithFixedDelay(r, delay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.pool.shutdown();
        this.schedulePool.shutdown();
    }
}

