/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.text.json;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.text.json.ReadJsonInterface;
import com.avaje.ebeaninternal.server.text.json.ReadJsonSource;

public class ReadBasicJsonContext
implements ReadJsonInterface {
    private final ReadJsonSource src;
    private char tokenStart;
    private String tokenKey;
    private boolean pushedTokenKey;

    public ReadBasicJsonContext(ReadJsonSource src) {
        this.src = src;
    }

    public void pushTokenKey() {
        this.pushedTokenKey = true;
    }

    public char getToken() {
        return this.tokenStart;
    }

    @Override
    public String getTokenKey() {
        return this.tokenKey;
    }

    public boolean isTokenKey() {
        return '\"' == this.tokenStart;
    }

    public boolean isTokenObjectEnd() {
        return '}' == this.tokenStart;
    }

    public boolean readObjectBegin() {
        this.readNextToken();
        if ('{' == this.tokenStart) {
            return true;
        }
        if ('n' == this.tokenStart) {
            return false;
        }
        if (']' == this.tokenStart) {
            return false;
        }
        throw new RuntimeException("Expected object begin at " + this.src.getErrorHelp());
    }

    @Override
    public boolean readKeyNext() {
        this.readNextToken();
        if ('\"' == this.tokenStart) {
            return true;
        }
        if ('}' == this.tokenStart) {
            return false;
        }
        throw new RuntimeException("Expected '\"' or '}' at " + this.src.getErrorHelp());
    }

    @Override
    public boolean readValueNext() {
        this.readNextToken();
        if (',' == this.tokenStart) {
            return true;
        }
        if ('}' == this.tokenStart) {
            return false;
        }
        throw new RuntimeException("Expected ',' or '}' at " + this.src.getErrorHelp() + " but got " + this.tokenStart);
    }

    public boolean readArrayBegin() {
        this.readNextToken();
        if ('[' == this.tokenStart) {
            return true;
        }
        if ('n' == this.tokenStart) {
            return false;
        }
        throw new RuntimeException("Expected array begin at " + this.src.getErrorHelp());
    }

    @Override
    public boolean readArrayNext() {
        this.readNextToken();
        if (',' == this.tokenStart) {
            return true;
        }
        if (']' == this.tokenStart) {
            return false;
        }
        throw new RuntimeException("Expected ',' or ']' at " + this.src.getErrorHelp());
    }

    public void readNextToken() {
        if (this.pushedTokenKey) {
            this.pushedTokenKey = false;
            return;
        }
        this.ignoreWhiteSpace();
        this.tokenStart = this.src.nextChar("EOF finding next token");
        switch (this.tokenStart) {
            case '\"': {
                this.internalReadKey();
                break;
            }
            case '{': {
                break;
            }
            case '}': {
                break;
            }
            case '[': {
                break;
            }
            case ']': {
                break;
            }
            case ',': {
                break;
            }
            case ':': {
                break;
            }
            case 'n': {
                this.internalReadNull();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected tokenStart[" + this.tokenStart + "] " + this.src.getErrorHelp());
            }
        }
    }

    @Override
    public String readQuotedValue() {
        boolean escape = false;
        StringBuilder sb = new StringBuilder();
        block13: while (true) {
            char ch = this.src.nextChar("EOF reading quoted value");
            if (escape) {
                escape = false;
                switch (ch) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'u': {
                        String msg = "EOF reading unicode value";
                        char c1 = this.src.nextChar(msg);
                        char c2 = this.src.nextChar(msg);
                        char c3 = this.src.nextChar(msg);
                        char c4 = this.src.nextChar(msg);
                        char u = (char)Integer.parseInt("" + c1 + c2 + c3 + c4, 16);
                        sb.append(u);
                        break;
                    }
                    default: {
                        sb.append('\\');
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\\': {
                    escape = true;
                    continue block13;
                }
                case '\"': {
                    return sb.toString();
                }
            }
            sb.append(ch);
        }
    }

    @Override
    public String readUnquotedValue(char c) {
        String v = this.readUnquotedValueRaw(c);
        if ("null".equals(v)) {
            return null;
        }
        return v;
    }

    private String readUnquotedValueRaw(char c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c);
        while (true) {
            this.tokenStart = this.src.nextChar("EOF reading unquoted value");
            switch (this.tokenStart) {
                case ',': {
                    this.src.back();
                    return sb.toString();
                }
                case '}': {
                    this.src.back();
                    return sb.toString();
                }
                case ' ': {
                    return sb.toString();
                }
                case '\t': {
                    return sb.toString();
                }
                case '\r': {
                    return sb.toString();
                }
                case '\n': {
                    return sb.toString();
                }
            }
            sb.append(this.tokenStart);
        }
    }

    private void internalReadNull() {
        StringBuilder sb = new StringBuilder(4);
        sb.append(this.tokenStart);
        for (int i = 0; i < 3; ++i) {
            char c = this.src.nextChar("EOF reading null ");
            sb.append(c);
        }
        if (!"null".equals(sb.toString())) {
            throw new TextException("Expected 'null' but got " + sb.toString() + " " + this.src.getErrorHelp());
        }
    }

    private void internalReadKey() {
        char c;
        StringBuilder sb = new StringBuilder();
        while (true) {
            if ('\"' == (c = this.src.nextChar("EOF reading key"))) break;
            sb.append(c);
        }
        this.tokenKey = sb.toString();
        this.ignoreWhiteSpace();
        c = this.src.nextChar("EOF reading ':'");
        if (':' != c) {
            throw new TextException("Expected to find colon after key at " + (this.src.pos() - 1) + " but found [" + c + "]" + this.src.getErrorHelp());
        }
    }

    @Override
    public void ignoreWhiteSpace() {
        this.src.ignoreWhiteSpace();
    }

    @Override
    public char nextChar() {
        this.tokenStart = this.src.nextChar("EOF getting nextChar for raw json");
        return this.tokenStart;
    }
}

