/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.server.transaction.JdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class JtaTransaction
extends JdbcTransaction {
    private UserTransaction userTransaction;
    private DataSource dataSource;
    private boolean commmitted = false;
    private boolean newTransaction = false;

    public JtaTransaction(String id, boolean explicit, UserTransaction utx, DataSource ds, TransactionManager manager) {
        super(id, explicit, null, manager);
        this.userTransaction = utx;
        this.dataSource = ds;
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        try {
            this.connection = this.dataSource.getConnection();
            if (this.connection == null) {
                throw new PersistenceException("The DataSource returned a null connection.");
            }
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (this.commmitted) {
            throw new PersistenceException("This transaction has already been committed.");
        }
        try {
            try {
                if (this.newTransaction) {
                    this.userTransaction.commit();
                }
                this.notifyCommit();
            }
            finally {
                this.close();
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        this.commmitted = true;
    }

    @Override
    public void rollback() {
        this.rollback(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Throwable e) {
        if (!this.commmitted) {
            try {
                try {
                    if (this.userTransaction != null) {
                        if (this.newTransaction) {
                            this.userTransaction.rollback();
                        } else {
                            this.userTransaction.setRollbackOnly();
                        }
                    }
                    this.notifyRollback(e);
                }
                finally {
                    this.closeConnection();
                }
            }
            catch (Exception ex) {
                throw new PersistenceException((Throwable)ex);
            }
        }
    }

    private void closeConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }
}

