/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.io.File;
import javax.servlet.ServletConfig;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.CollectionRenderer;
import org.tmatesoft.svn.core.internal.server.dav.DefaultCollectionRenderer;
import org.tmatesoft.svn.core.internal.server.dav.SVNPathBasedAccess;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVConfig {
    private static final String PATH_DIRECIVE = "SVNPath";
    private static final String PARENT_PATH_DIRECIVE = "SVNParentPath";
    private static final String SVN_ACCESS_FILE_DIRECTIVE = "AuthzSVNAccessFile";
    private static final String SVN_ANONYMOUS_DIRECTIVE = "AuthzSVNAnonymous";
    private static final String SVN_NO_AUTH_IF_ANONYMOUS_ALLOWED_DIRECIVE = "AuthzSVNNoAuthWhenAnonymousAllowed";
    private static final String LIST_PARENT_PATH_DIRECTIVE = "SVNListParentPath";
    private static final String REPOS_NAME = "SVNReposName";
    private static final String XSLT_INDEX = "SVNIndexXSLT";
    private static final String ACTIVITIES_DB = "SVNActivitiesDB";
    private static final String AUTOVERSIONING = "SVNAutoversioning";
    private static final String ALLOW_BULK_UPDATES = "SVNAllowBulkUpdates";
    private static final String DAV_DEPTH = "DAVDepthInfinity";
    private static final String OFF = "off";
    private static final String ON = "on";
    private String myRepositoryPath;
    private String myRepositoryParentPath;
    private String myRepositoryName;
    private String myXSLTIndex;
    private String myActivitiesDBPath;
    private SVNPathBasedAccess mySVNAccess = null;
    private boolean myUsingPBA = false;
    private boolean myAnonymous = true;
    private boolean myNoAuthIfAnonymousAllowed = false;
    private boolean myIsListParentPath = false;
    private boolean myIsAutoVersioning = false;
    private boolean myIsAllowBulkUpdates = false;
    private boolean myIsAllowDepthInfinity = false;
    private CollectionRenderer collectionRenderer;

    public DAVConfig() {
    }

    public DAVConfig(ServletConfig servletConfig) throws SVNException {
        String allowDepthInfinity;
        String allowBulkUpdates;
        String autoversioning;
        String listParentPath;
        String noAuthIfAnonymousAllowed;
        String anonymous;
        String repositoryPath = servletConfig.getInitParameter(PATH_DIRECIVE);
        String repositoryParentPath = servletConfig.getInitParameter(PARENT_PATH_DIRECIVE);
        this.myRepositoryName = servletConfig.getInitParameter(REPOS_NAME);
        this.myXSLTIndex = servletConfig.getInitParameter(XSLT_INDEX);
        if (repositoryPath != null && repositoryParentPath == null) {
            this.myRepositoryPath = repositoryPath;
            this.myRepositoryParentPath = null;
        } else if (repositoryParentPath != null && repositoryPath == null) {
            this.myRepositoryParentPath = repositoryParentPath;
            this.myRepositoryPath = null;
        } else if (repositoryPath == null) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"Neither SVNPath nor SVNParentPath directive were specified."), (SVNLogType)SVNLogType.NETWORK);
        } else {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"Only one of SVNPath and SVNParentPath directives should be specified."), (SVNLogType)SVNLogType.NETWORK);
        }
        String configurationFilePath = servletConfig.getInitParameter(SVN_ACCESS_FILE_DIRECTIVE);
        if (configurationFilePath != null) {
            this.myUsingPBA = true;
            try {
                this.mySVNAccess = new SVNPathBasedAccess(new File(configurationFilePath));
            }
            catch (SVNException e) {
                this.mySVNAccess = null;
            }
        }
        if ((anonymous = servletConfig.getInitParameter(SVN_ANONYMOUS_DIRECTIVE)) != null && OFF.equals(anonymous)) {
            this.myAnonymous = false;
        }
        if ((noAuthIfAnonymousAllowed = servletConfig.getInitParameter(SVN_NO_AUTH_IF_ANONYMOUS_ALLOWED_DIRECIVE)) != null && ON.equals(noAuthIfAnonymousAllowed)) {
            this.myNoAuthIfAnonymousAllowed = true;
        }
        if ((listParentPath = servletConfig.getInitParameter(LIST_PARENT_PATH_DIRECTIVE)) != null && ON.equals(listParentPath)) {
            this.myIsListParentPath = true;
        }
        if ((autoversioning = servletConfig.getInitParameter(AUTOVERSIONING)) != null && ON.equals(autoversioning)) {
            this.myIsAutoVersioning = true;
        }
        if ((allowBulkUpdates = servletConfig.getInitParameter(ALLOW_BULK_UPDATES)) != null && ON.equals(allowBulkUpdates)) {
            this.myIsAllowBulkUpdates = true;
        }
        if ((allowDepthInfinity = servletConfig.getInitParameter(DAV_DEPTH)) != null && ON.equals(allowDepthInfinity)) {
            this.myIsAllowDepthInfinity = true;
        }
        this.myActivitiesDBPath = servletConfig.getInitParameter(ACTIVITIES_DB);
    }

    public boolean isAllowDepthInfinity() {
        return this.myIsAllowDepthInfinity;
    }

    public String getRepositoryName() {
        return this.myRepositoryName;
    }

    public String getXSLTIndex() {
        return this.myXSLTIndex;
    }

    public boolean isUsingRepositoryPathDirective() {
        return this.myRepositoryPath != null;
    }

    public String getRepositoryPath() {
        return this.myRepositoryPath;
    }

    public String getRepositoryParentPath() {
        return this.myRepositoryParentPath;
    }

    public SVNPathBasedAccess getSVNAccess() {
        return this.mySVNAccess;
    }

    public boolean isUsingPBA() {
        return this.myUsingPBA;
    }

    public boolean isAnonymousAllowed() {
        return this.myAnonymous;
    }

    public boolean isNoAuthIfAnonymousAllowed() {
        return this.myNoAuthIfAnonymousAllowed;
    }

    public boolean isListParentPath() {
        return this.myIsListParentPath;
    }

    public String getActivitiesDBPath() {
        return this.myActivitiesDBPath;
    }

    public boolean isAutoVersioning() {
        return this.myIsAutoVersioning;
    }

    public boolean isAllowBulkUpdates() {
        return this.myIsAllowBulkUpdates;
    }

    public CollectionRenderer getCollectionRenderer() {
        if (this.collectionRenderer == null) {
            this.collectionRenderer = new DefaultCollectionRenderer();
        }
        return this.collectionRenderer;
    }
}

