/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVDepth {
    public static final DAVDepth DEPTH_ZERO = new DAVDepth(0, "0");
    public static final DAVDepth DEPTH_ONE = new DAVDepth(1, "1");
    public static final DAVDepth DEPTH_INFINITY = new DAVDepth(Integer.MAX_VALUE, "infinity");
    private int myID;
    private String myName;

    private DAVDepth(int id, String name) {
        this.myID = id;
        this.myName = name;
    }

    public int getID() {
        return this.myID;
    }

    public String toString() {
        return this.myName;
    }

    public static DAVDepth parseDepth(String depth) {
        if (DEPTH_INFINITY.toString().equalsIgnoreCase(depth)) {
            return DEPTH_INFINITY;
        }
        if (DEPTH_ZERO.toString().equalsIgnoreCase(depth)) {
            return DEPTH_ZERO;
        }
        if (DEPTH_ONE.toString().equalsIgnoreCase(depth)) {
            return DEPTH_ONE;
        }
        return null;
    }

    public static DAVDepth decreaseDepth(DAVDepth currentDepth) throws SVNException {
        if (currentDepth == null) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_MALFORMED_DATA, (String)"Depth is not specified."), (SVNLogType)SVNLogType.NETWORK);
        }
        if (currentDepth == DEPTH_ZERO || currentDepth == DEPTH_INFINITY) {
            return currentDepth;
        }
        return DEPTH_ZERO;
    }
}

