/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;

public class DAVPrivateResourceHelper
extends DAVResourceHelper {
    @Override
    protected void prepare(DAVResource resource) throws DAVException {
    }

    @Override
    protected DAVResource getParentResource(DAVResource resource) throws DAVException {
        DAVResourceHelper.throwIllegalGetParentResourceError(resource);
        return null;
    }

    public static DAVResource createPrivateResource(DAVResource resource, DAVResourceKind resourceKind) {
        DAVResource privateResource = new DAVResource();
        resource.copyTo(privateResource);
        DAVResourceURI resourceURI = privateResource.getResourceURI();
        resourceURI.setKind(resourceKind);
        resourceURI.setType(DAVResourceType.PRIVATE);
        String path = "/!svn/" + resourceKind.toString();
        resourceURI.setURI(path);
        resourceURI.setPath(null);
        privateResource.setCollection(true);
        privateResource.setExists(true);
        privateResource.setRevision(-1L);
        return privateResource;
    }
}

