/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVRegularResourceHelper
extends DAVResourceHelper {
    @Override
    protected void prepare(DAVResource resource) throws DAVException {
        if (!SVNRevision.isValidRevisionNumber((long)resource.getRevision())) {
            try {
                resource.setRevision(resource.getLatestRevision());
            }
            catch (SVNException e) {
                throw DAVException.convertError(e.getErrorMessage(), 500, "Could not determine the proper revision to access", null);
            }
        }
        FSRoot root = resource.getRoot();
        FSFS fsfs = resource.getFSFS();
        if (root == null) {
            try {
                root = fsfs.createRevisionRoot(resource.getRevision());
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not open the root of the repository", null);
            }
            resource.setRoot(root);
        }
        SVNNodeKind kind = DAVServletUtil.checkPath(root, resource.getResourceURI().getPath());
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "resource path is " + resource.getResourceURI().getPath());
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "resource kind is " + kind);
        resource.setExists(kind != SVNNodeKind.NONE);
        resource.setCollection(kind == SVNNodeKind.DIR);
    }

    @Override
    protected DAVResource getParentResource(DAVResource resource) throws DAVException {
        DAVResource parentResource = new DAVResource();
        resource.copyTo(parentResource);
        DAVResourceURI parentResourceURI = parentResource.getResourceURI();
        String uri = parentResourceURI.getURI();
        String path = parentResourceURI.getPath();
        parentResourceURI.setURI(SVNPathUtil.removeTail((String)uri));
        parentResourceURI.setPath(SVNPathUtil.removeTail((String)path));
        parentResource.setExists(true);
        parentResource.setCollection(true);
        parentResource.setVersioned(true);
        return parentResource;
    }
}

