/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVActivityResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVHistoryResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockRecType;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVPrivateResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVRegularResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.DAVVersionResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVWorkingResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class DAVResourceHelper {
    private static final Map ourResourceHelpers = new HashMap();

    protected abstract void prepare(DAVResource var1) throws DAVException;

    protected abstract DAVResource getParentResource(DAVResource var1) throws DAVException;

    public static void prepareResource(DAVResource resource) throws DAVException {
        DAVResourceURI resourceURI = resource.getResourceURI();
        DAVResourceType resourceType = resourceURI.getType();
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "resource type is " + resourceType.toString());
        DAVResourceHelper helperImpl = DAVResourceHelper.getHelper(resourceType);
        helperImpl.prepare(resource);
    }

    public static DAVResource createParentResource(DAVResource resource) throws DAVException {
        DAVResourceURI resourceURI = resource.getResourceURI();
        DAVResourceType resourceType = resourceURI.getType();
        DAVResourceHelper helperImpl = DAVResourceHelper.getHelper(resourceType);
        return helperImpl.getParentResource(resource);
    }

    public static DAVResource getDirectResource(DAVLockInfoProvider lockProvider, String lockToken, DAVResource resource) throws DAVException {
        while (resource != null) {
            DAVLock lock = lockProvider.findLock(resource, lockToken);
            if (lock == null) {
                throw new DAVException("The specified locktoken does not correspond to an existing lock on this resource.", 400, 0);
            }
            if (lock.getRecType() == DAVLockRecType.DIRECT) {
                return resource;
            }
            resource = DAVResourceHelper.createParentResource(resource);
        }
        throw new DAVException("The lock database is corrupt. A direct lock could not be found for the corresponding indirect lock on this resource.", 500, 0);
    }

    public static void throwIllegalGetParentResourceError(DAVResource resource) throws DAVException {
        DAVResourceURI uri = resource.getResourceURI();
        throw new DAVException("getParentResource() was called for {0} (type {1})", new Object[]{uri.getRequestURI(), uri.getType()}, 500, 0);
    }

    public static void convertWorkingToRegular(DAVResource resource) throws DAVException {
        DAVResourceURI uri = resource.getResourceURI();
        uri.setType(DAVResourceType.REGULAR);
        resource.setWorking(false);
        String path = null;
        FSFS fsfs = resource.getFSFS();
        if (!SVNRevision.isValidRevisionNumber((long)resource.getRevision())) {
            long rev = -1L;
            try {
                rev = resource.getLatestRevision();
            }
            catch (SVNException e) {
                throw DAVException.convertError(e.getErrorMessage(), 500, "Could not determine youngest rev.", null);
            }
            resource.setRevision(rev);
            path = uri.getPath();
        } else {
            path = DAVPathUtil.buildURI(uri.getContext(), DAVResourceKind.BASELINE_COLL, resource.getRevision(), uri.getPath(), false);
        }
        path = SVNEncodingUtil.uriEncode((String)path);
        uri.setURI(path);
        try {
            resource.setRoot((FSRoot)fsfs.createRevisionRoot(resource.getRevision()));
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not open revision root.", null);
        }
    }

    private static DAVResourceHelper getHelper(DAVResourceType resourceType) throws DAVException {
        DAVResourceHelper helperImpl = (DAVResourceHelper)ourResourceHelpers.get(resourceType);
        if (helperImpl == null) {
            throw new DAVException("DESIGN FAILURE: unknown resource type", null, 500, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
        }
        return helperImpl;
    }

    protected static synchronized void registerHelper(DAVResourceType resourceType, DAVResourceHelper factoryImpl) {
        ourResourceHelpers.put(resourceType, factoryImpl);
    }

    static {
        DAVResourceHelper.registerHelper(DAVResourceType.WORKING, new DAVWorkingResourceHelper());
        DAVResourceHelper.registerHelper(DAVResourceType.REGULAR, new DAVRegularResourceHelper());
        DAVResourceHelper.registerHelper(DAVResourceType.ACTIVITY, new DAVActivityResourceHelper());
        DAVResourceHelper.registerHelper(DAVResourceType.HISTORY, new DAVHistoryResourceHelper());
        DAVResourceHelper.registerHelper(DAVResourceType.PRIVATE, new DAVPrivateResourceHelper());
        DAVResourceHelper.registerHelper(DAVResourceType.VERSION, new DAVVersionResourceHelper());
    }
}

