/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVResourceURI {
    public static final String SPECIAL_URI = "!svn";
    public static final String DEDAULT_VCC_NAME = "default";
    private String myURI;
    private String myContext;
    private DAVResourceType myType;
    private DAVResourceKind myKind;
    private long myRevision;
    private String myPath;
    private String myActivityID;
    private boolean myIsExists = false;
    private boolean myIsVersioned = false;
    private boolean myIsBaseLined = false;
    private boolean myIsWorking = false;

    public DAVResourceURI(String context, String uri, String label, boolean useCheckedIn) throws SVNException {
        this(context, uri, label, useCheckedIn, -1L);
    }

    public DAVResourceURI(String context, String uri, String label, boolean useCheckedIn, long revision) throws SVNException {
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append('\n');
        logBuffer.append("uri: " + uri);
        logBuffer.append('\n');
        logBuffer.append("label: " + label);
        logBuffer.append('\n');
        logBuffer.append("context: " + context);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, logBuffer.toString());
        this.myURI = uri == null ? "" : uri;
        this.myContext = context;
        this.myRevision = revision;
        this.parseURI(label, useCheckedIn);
        logBuffer.delete(0, logBuffer.length());
        logBuffer.append('\n');
        logBuffer.append("DAVResourceURI.getRequestURI(): " + this.getRequestURI());
        logBuffer.append('\n');
        logBuffer.append("DAVResourceURI.getURI(): " + this.getURI());
        logBuffer.append('\n');
        logBuffer.append("DAVResourceURI.getPath(): " + this.getPath());
        logBuffer.append('\n');
        logBuffer.append("DAVResourceURI.getContext(): " + this.getContext());
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, logBuffer.toString());
    }

    public DAVResourceURI(String context, String uri, String path, long revision, DAVResourceKind kind, DAVResourceType type, String activityID, boolean exists, boolean isVersioned, boolean isBaseLined, boolean isWorking) {
        this.myContext = context;
        this.myURI = uri;
        this.myPath = path;
        this.myActivityID = activityID;
        this.myRevision = revision;
        this.myType = type;
        this.myKind = kind;
        this.myIsExists = exists;
        this.myIsVersioned = isVersioned;
        this.myIsBaseLined = isBaseLined;
        this.myIsWorking = isWorking;
    }

    public DAVResourceURI() {
    }

    public DAVResourceURI dup() {
        return new DAVResourceURI(this.myContext, this.myURI, this.myPath, this.myRevision, this.myKind, this.myType, this.myActivityID, this.myIsExists, this.myIsVersioned, this.myIsBaseLined, this.myIsWorking);
    }

    public String getRequestURI() {
        return SVNPathUtil.append((String)this.getContext(), (String)this.getURI());
    }

    public String getContext() {
        return this.myContext;
    }

    public String getURI() {
        return this.myURI;
    }

    public void setURI(String uri) {
        this.myURI = uri;
    }

    public DAVResourceType getType() {
        return this.myType;
    }

    public DAVResourceKind getKind() {
        return this.myKind;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getActivityID() {
        return this.myActivityID;
    }

    public boolean exists() {
        return this.myIsExists;
    }

    public boolean isVersioned() {
        return this.myIsVersioned;
    }

    public boolean isBaseLined() {
        return this.myIsBaseLined;
    }

    public boolean isWorking() {
        return this.myIsWorking;
    }

    public void setExists(boolean isExist) {
        this.myIsExists = isExist;
    }

    public void setPath(String path) {
        this.myPath = DAVPathUtil.standardize(path);
    }

    public void setVersioned(boolean isVersioned) {
        this.myIsVersioned = isVersioned;
    }

    public void setKind(DAVResourceKind kind) {
        this.myKind = kind;
    }

    public void setType(DAVResourceType type) {
        this.myType = type;
    }

    public void setRevision(long revisionNumber) {
        this.myRevision = revisionNumber;
    }

    public void setWorking(boolean isWorking) {
        this.myIsWorking = isWorking;
    }

    public void setActivityID(String activityID) {
        this.myActivityID = activityID;
    }

    public void setBaseLined(boolean isBaseLined) {
        this.myIsBaseLined = isBaseLined;
    }

    private void parseURI(String label, boolean useCheckedIn) throws SVNException {
        if (!SPECIAL_URI.equals(DAVPathUtil.head(this.getURI()))) {
            this.setKind(DAVResourceKind.PUBLIC);
            this.setType(DAVResourceType.REGULAR);
            this.setPath(this.getURI());
            this.setVersioned(true);
        } else {
            String specialPart = DAVPathUtil.removeHead(this.getURI(), false);
            if (specialPart.length() == 0) {
                this.setType(DAVResourceType.PRIVATE);
                this.setKind(DAVResourceKind.ROOT_COLLECTION);
            } else if (!(specialPart = DAVPathUtil.dropLeadingSlash(specialPart)).endsWith("/") && SVNPathUtil.getSegmentsCount((String)specialPart) == 1) {
                this.setType(DAVResourceType.PRIVATE);
            } else {
                DAVResourceKind kind = DAVResourceKind.parseKind(DAVPathUtil.head(specialPart));
                if (kind != DAVResourceKind.UNKNOWN) {
                    this.setKind(kind);
                    String parameter = DAVPathUtil.removeHead(specialPart, false);
                    parameter = DAVPathUtil.dropLeadingSlash(parameter);
                    if (kind == DAVResourceKind.VCC) {
                        this.parseVCC(parameter, label, useCheckedIn);
                    } else if (kind == DAVResourceKind.VERSION) {
                        this.parseVersion(parameter);
                    } else if (kind == DAVResourceKind.BASELINE) {
                        this.parseBaseline(parameter);
                    } else if (kind == DAVResourceKind.BASELINE_COLL) {
                        this.parseBaselineCollection(parameter);
                    } else if (kind == DAVResourceKind.ACT_COLLECTION) {
                        this.parseActivity(parameter);
                    } else if (kind == DAVResourceKind.HISTORY) {
                        this.parseHistory(parameter);
                    } else if (kind == DAVResourceKind.WRK_BASELINE) {
                        this.parseWorkingBaseline(parameter);
                    } else if (kind == DAVResourceKind.WORKING) {
                        this.parseWorking(parameter);
                    }
                }
            }
        }
    }

    private void parseWorking(String parameter) {
        this.setType(DAVResourceType.WORKING);
        this.setVersioned(true);
        this.setWorking(true);
        if (SVNPathUtil.getSegmentsCount((String)parameter) == 1) {
            this.setActivityID(parameter);
            this.setPath("/");
        } else {
            this.setActivityID(DAVPathUtil.head(parameter));
            String path = DAVPathUtil.removeHead(parameter, false);
            this.setPath(path);
        }
    }

    private void parseWorkingBaseline(String parameter) throws SVNException {
        this.setType(DAVResourceType.WORKING);
        this.setWorking(true);
        this.setVersioned(true);
        this.setBaseLined(true);
        if (SVNPathUtil.getSegmentsCount((String)parameter) == 1) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (String)"Invalid URI ''{0}''", (Object)this.getRequestURI()), (SVNLogType)SVNLogType.NETWORK);
        }
        this.setActivityID(DAVPathUtil.head(parameter));
        try {
            String revisionParameter = DAVPathUtil.removeHead(parameter, false);
            long revision = Long.parseLong(DAVPathUtil.dropLeadingSlash(revisionParameter));
            this.setRevision(revision);
        }
        catch (NumberFormatException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (Throwable)e), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
        }
    }

    private void parseHistory(String parameter) {
        this.setType(DAVResourceType.HISTORY);
        this.setPath(parameter);
    }

    private void parseActivity(String parameter) {
        this.setType(DAVResourceType.ACTIVITY);
        this.setActivityID(parameter);
    }

    private void parseBaselineCollection(String parameter) throws SVNException {
        String parameterPath;
        long revision = -1L;
        if (SVNPathUtil.getSegmentsCount((String)parameter) == 1) {
            parameterPath = "/";
            try {
                revision = Long.parseLong(parameter);
            }
            catch (NumberFormatException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (String)e.getMessage()), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
            }
        } else {
            try {
                revision = Long.parseLong(DAVPathUtil.head(parameter));
            }
            catch (NumberFormatException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (String)e.getMessage()), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
            }
            parameterPath = DAVPathUtil.removeHead(parameter, false);
        }
        this.setType(DAVResourceType.REGULAR);
        this.setVersioned(true);
        this.setRevision(revision);
        this.setPath(parameterPath);
    }

    private void parseBaseline(String parameter) throws SVNException {
        try {
            this.setRevision(Long.parseLong(parameter));
        }
        catch (NumberFormatException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (String)e.getMessage()), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
        }
        this.setVersioned(true);
        this.setBaseLined(true);
        this.setType(DAVResourceType.VERSION);
    }

    private void parseVersion(String parameter) throws SVNException {
        this.setVersioned(true);
        this.setType(DAVResourceType.VERSION);
        if (SVNPathUtil.getSegmentsCount((String)parameter) == 1) {
            try {
                this.setRevision(Long.parseLong(parameter));
            }
            catch (NumberFormatException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (String)"Invalid URI ''{0}''", (Object)e.getMessage()), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
            }
            this.setPath("/");
        } else {
            try {
                this.setRevision(Long.parseLong(DAVPathUtil.head(parameter)));
            }
            catch (NumberFormatException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (String)e.getMessage()), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
            }
            this.setPath(DAVPathUtil.removeHead(parameter, false));
        }
    }

    private void parseVCC(String parameter, String label, boolean useCheckedIn) throws SVNException {
        if (!DEDAULT_VCC_NAME.equals(parameter)) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Invalid VCC name ''{0}''", (Object)parameter), (SVNLogType)SVNLogType.NETWORK);
        }
        if (label == null && !useCheckedIn) {
            this.setType(DAVResourceType.PRIVATE);
            this.setExists(true);
            this.setVersioned(true);
            this.setBaseLined(true);
        } else {
            long revision = -1L;
            if (label != null) {
                try {
                    revision = Long.parseLong(label);
                }
                catch (NumberFormatException e) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_ILLEGAL_URL, (String)"Invalid label header ''{0}''", (Object)label), (SVNLogType)SVNLogType.NETWORK);
                }
            }
            this.setType(DAVResourceType.VERSION);
            this.setRevision(revision);
            this.setVersioned(true);
            this.setBaseLined(true);
            this.setPath(null);
        }
    }
}

