/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class DAVVersionResourceHelper
extends DAVResourceHelper {
    @Override
    protected void prepare(DAVResource resource) throws DAVException {
        if (!SVNRevision.isValidRevisionNumber((long)resource.getRevision())) {
            try {
                resource.setRevision(resource.getLatestRevision());
            }
            catch (SVNException e) {
                throw DAVException.convertError(e.getErrorMessage(), 500, "Could not fetch 'youngest' revision to enable accessing the latest baseline resource.", null);
            }
        }
        FSRoot root = resource.getRoot();
        FSFS fsfs = resource.getFSFS();
        if (root == null) {
            try {
                root = fsfs.createRevisionRoot(resource.getRevision());
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not open a revision root.", null);
            }
            resource.setRoot(root);
        }
        resource.getResourceURI().setURI(DAVPathUtil.buildURI(null, DAVResourceKind.BASELINE, resource.getRevision(), null, false));
        resource.setExists(true);
    }

    @Override
    protected DAVResource getParentResource(DAVResource resource) throws DAVException {
        DAVResourceHelper.throwIllegalGetParentResourceError(resource);
        return null;
    }

    public static DAVResource createVersionResource(DAVResource resource, String uri) throws DAVException {
        DAVResourceURI regularResourceURI = null;
        try {
            regularResourceURI = new DAVResourceURI(resource.getResourceURI().getContext(), uri, null, false);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not parse version resource uri.", null);
        }
        return new DAVResource(resource.getRepository(), resource.getRepositoryManager(), regularResourceURI, resource.isSVNClient(), resource.getDeltaBase(), resource.getVersion(), resource.getClientOptions(), resource.getBaseChecksum(), resource.getResultChecksum(), resource.getUserName(), resource.getActivitiesDB(), resource.getLockTokens(), resource.getClientCapabilities());
    }
}

