/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.tmatesoft.svn.core.internal.util.SVNBase64;

public class DAVBase64OutputStream
extends OutputStream {
    private static final int BASE64_LINE_LENGTH = 57;
    private Writer myWriter;
    private ByteArrayOutputStream myBuffer;

    public DAVBase64OutputStream(Writer dst) {
        this.myWriter = dst;
        this.myBuffer = new ByteArrayOutputStream(100);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int needed = 57 - this.myBuffer.size();
            int toWrite = Math.min(needed, len);
            this.myBuffer.write(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
            if (this.myBuffer.size() != 57) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.myBuffer.size() > 0) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.myWriter.write(SVNBase64.byteArrayToBase64((byte[])this.myBuffer.toByteArray()) + "\n");
        this.myBuffer.reset();
    }
}

