/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.handlers.LivePropertySpecification;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVElementProperty {
    private ArrayList myValues;
    private Map myAttributes;
    private List myChildren;
    private DAVElement myElementName;
    private DAVElementProperty myParent;
    private LivePropertySpecification myLivePropertySpec;

    public DAVElementProperty(DAVElement elementName, DAVElementProperty parent) {
        this.myElementName = elementName;
        this.myParent = parent;
    }

    public DAVElementProperty getParent() {
        return this.myParent;
    }

    public DAVElement getName() {
        return this.myElementName;
    }

    public void setElementName(DAVElement element) {
        this.myElementName = element;
    }

    public boolean hasChild(DAVElement element) {
        return this.getChild(element) != null;
    }

    public DAVElementProperty getChild(DAVElement element) {
        if (this.myChildren != null) {
            for (DAVElementProperty nextChild : this.myChildren) {
                if (element != nextChild.getName()) continue;
                return nextChild;
            }
        }
        return null;
    }

    public Map getAttributes() {
        return this.myAttributes;
    }

    public void addValue(String cdata) throws SVNException {
        if (this.myChildren != null) {
            this.invalidXML();
        } else if (this.myValues == null) {
            this.myValues = new ArrayList();
        }
        this.myValues.add(cdata);
    }

    public String getFirstValue(boolean trim) {
        if (this.myValues != null) {
            String value = (String)this.myValues.get(0);
            if (trim && value != null) {
                value = value.trim();
            }
            return value;
        }
        return null;
    }

    public Collection getValues() {
        return this.myValues;
    }

    public String getAttributeValue(String name) {
        if (this.myAttributes != null) {
            return (String)this.myAttributes.get(name);
        }
        return null;
    }

    public void setAttributes(Attributes attributes) {
        this.myAttributes = this.getAttributesMap(attributes);
    }

    public List getChildren() {
        return this.myChildren;
    }

    public boolean isEmpty() {
        return !(this.myChildren != null && !this.myChildren.isEmpty() || this.myValues != null && !this.myValues.isEmpty());
    }

    protected DAVElementProperty addChild(DAVElement element, Attributes attrs) throws SVNException {
        if (this.myValues != null) {
            this.invalidXML();
        } else if (this.myChildren == null) {
            this.myChildren = new LinkedList();
        }
        DAVElementProperty child = new DAVElementProperty(element, this);
        this.myChildren.add(child);
        child.setAttributes(attrs);
        return child;
    }

    private Map getAttributesMap(Attributes attrs) {
        SVNHashMap attributes = null;
        if (attrs.getLength() != 0) {
            attributes = new SVNHashMap();
            for (int i = 0; i < attrs.getLength(); ++i) {
                attributes.put(attrs.getLocalName(i), attrs.getValue(i));
            }
        }
        return attributes;
    }

    private void invalidXML() throws SVNException {
        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.XML_MALFORMED, (String)"Malformed XML"), (SVNLogType)SVNLogType.NETWORK);
    }
}

