/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVFileRevisionsRequest
extends DAVRequest {
    private String myPath;
    private long myStartRevision = -1L;
    private long myEndRevision = -1L;
    private boolean myIsIncludeMergedRevisions;

    public String getPath() {
        return this.myPath;
    }

    public long getStartRevision() {
        return this.myStartRevision;
    }

    public long getEndRevision() {
        return this.myEndRevision;
    }

    public boolean isIncludeMergedRevisions() {
        return this.myIsIncludeMergedRevisions;
    }

    @Override
    protected void init() throws SVNException {
        DAVElementProperty rootElement = this.getRootElement();
        List children = rootElement.getChildren();
        for (DAVElementProperty childElement : children) {
            DAVElement childElementName = childElement.getName();
            if (!"svn:".equals(childElementName.getNamespace())) continue;
            if (childElementName == DAVElement.PATH) {
                String path = childElement.getFirstValue(false);
                DAVPathUtil.testCanonical(path);
                this.myPath = path;
                continue;
            }
            if (childElementName == DAVElement.START_REVISION) {
                try {
                    this.myStartRevision = Long.parseLong(childElement.getFirstValue(true));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (childElementName == DAVElement.END_REVISION) {
                try {
                    this.myEndRevision = Long.parseLong(childElement.getFirstValue(true));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (childElementName != DAVElement.INCLUDE_MERGED_REVISIONS) continue;
            this.myIsIncludeMergedRevisions = true;
        }
    }
}

