/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockRecType;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockScope;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVLockRequest
extends DAVRequest {
    private static final DAVElement LOCK_INFO = DAVElement.getElement((String)"DAV:", (String)"lockinfo");

    public DAVLock parseLockInfo(DAVLockHandler handler, DAVResource resource, List namespaces) throws DAVException {
        DAVDepth depth = null;
        try {
            depth = handler.getRequestDepth(DAVDepth.DEPTH_ZERO);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 400, null, null);
        }
        if (depth != DAVDepth.DEPTH_ONE && depth != DAVDepth.DEPTH_ZERO) {
            throw new DAVException("An invalid Depth header was specified.", 400, 0);
        }
        Date timeout = handler.getTimeout();
        String lockToken = null;
        try {
            lockToken = FSRepositoryUtil.generateLockToken();
        }
        catch (SVNException e) {
            DAVException first = DAVException.convertError(e.getErrorMessage(), 500, "Failed to generate a lock token.", null);
            DAVException next = new DAVException("Could not parse the lockinfo due to an internal problem creating a lock structure.", first.getResponseCode(), first, 0);
            throw next;
        }
        DAVElementProperty rootElement = null;
        try {
            rootElement = this.getRoot();
        }
        catch (SVNException e) {
            throw DAVException.convertError(e.getErrorMessage(), 400, "Could not parse the lockinfo, malformed xml request", null);
        }
        String owner = null;
        DAVLockScope lockScope = DAVLockScope.UNKNOWN;
        DAVLockType lockType = DAVLockType.UNKNOWN;
        for (DAVElementProperty childElement : rootElement.getChildren()) {
            DAVElementProperty writeChild;
            DAVElement childElementName = childElement.getName();
            if (childElementName == DAVElement.LOCK_TYPE && childElement.getChildren() != null && lockType == DAVLockType.UNKNOWN && (writeChild = childElement.getChild(DAVElement.WRITE)) != null) {
                lockType = DAVLockType.WRITE;
                continue;
            }
            if (childElementName == DAVElement.LOCK_SCOPE && childElement.getChildren() != null && lockScope == DAVLockScope.UNKNOWN) {
                if (childElement.getChild(DAVElement.EXCLUSIVE) != null) {
                    lockScope = DAVLockScope.EXCLUSIVE;
                } else if (childElement.getChild(DAVElement.SHARED) != null) {
                    lockScope = DAVLockScope.SHARED;
                }
                if (lockScope != DAVLockScope.UNKNOWN) continue;
            }
            if (childElementName == DAVElement.LOCK_OWNER) {
                StringBuffer buffer = new StringBuffer();
                String namespace = childElementName.getNamespace();
                buffer.append("<");
                if (namespace == null || "".equals(namespace)) {
                    buffer.append(childElementName.getName());
                } else {
                    buffer.append(SVNXMLUtil.PREFIX_MAP.get(namespace));
                    buffer.append(":");
                    buffer.append(childElementName.getName());
                }
                Map attributes = childElement.getAttributes();
                if (attributes != null) {
                    for (String attrName : attributes.keySet()) {
                        String attrValue = (String)attributes.get(attrName);
                        buffer.append(" ");
                        buffer.append(attrName);
                        buffer.append("=\"");
                        buffer.append(attrValue);
                        buffer.append("\"");
                    }
                }
                for (String nextNamespace : namespaces) {
                    buffer.append(" xmlns:");
                    buffer.append(SVNXMLUtil.PREFIX_MAP.get(nextNamespace));
                    buffer.append("=\"");
                    buffer.append(nextNamespace);
                    buffer.append("\"");
                }
                if (childElement.isEmpty()) {
                    buffer.append(" />");
                } else {
                    buffer.append(">");
                    buffer.append(SVNEncodingUtil.xmlEncodeCDATA((String)childElement.getFirstValue(false), (boolean)false));
                    buffer.append("</");
                    if (namespace == null || "".equals(namespace)) {
                        buffer.append(childElementName.getName());
                    } else {
                        buffer.append(SVNXMLUtil.PREFIX_MAP.get(namespace));
                        buffer.append(":");
                        buffer.append(childElementName.getName());
                    }
                    buffer.append(">");
                }
                owner = buffer.toString();
                continue;
            }
            throw new DAVException("The server cannot satisfy the LOCK request due to an unknown XML element (\"{0}\") within the DAV:lockinfo element.", new Object[]{childElementName.getName()}, 412, 0);
        }
        return new DAVLock(resource.getUserName(), depth, resource.exists(), lockToken, owner, DAVLockRecType.DIRECT, lockScope, lockType, timeout);
    }

    @Override
    protected void init() throws SVNException {
        if (this.getRoot().getName() != LOCK_INFO) {
            this.invalidXMLRoot();
        }
    }

    protected DAVElementProperty getRoot() throws SVNException {
        if (this.getRootElement() == null) {
            this.invalidXMLRoot();
        }
        return this.getRootElement();
    }

    protected void invalidXMLRoot() throws SVNException {
        throw new DAVException("The request body contains an unexpected XML root element.", null, 400, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
    }
}

