/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLogRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class DAVLogHandler
extends DAVReportHandler
implements ISVNLogEntryHandler {
    private DAVLogRequest myDAVRequest;
    private int myDepth = 0;
    private DAVReportHandler myCommonReportHandler;

    public DAVLogHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(repositoryManager, request, response);
        this.myCommonReportHandler = commonReportHandler;
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getLogRequest();
    }

    private DAVLogRequest getLogRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVLogRequest();
        }
        return this.myDAVRequest;
    }

    private int getDepth() {
        return this.myDepth;
    }

    private void increaseDepth() {
        ++this.myDepth;
    }

    private void decreaseDepth() {
        --this.myDepth;
    }

    @Override
    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace(null);
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        this.writeXMLHeader(null);
        for (int i = 0; i < this.getLogRequest().getTargetPaths().length; ++i) {
            String currentPath = this.getLogRequest().getTargetPaths()[i];
            DAVPathUtil.testCanonical(currentPath);
            this.getLogRequest().getTargetPaths()[i] = SVNPathUtil.append((String)this.getDAVResource().getResourceURI().getPath(), (String)currentPath);
        }
        DAVLogRequest logRequest = this.getLogRequest();
        this.getDAVResource().getRepository().log(logRequest.getTargetPaths(), logRequest.getStartRevision(), logRequest.getEndRevision(), logRequest.isDiscoverChangedPaths(), logRequest.isStrictNodeHistory(), logRequest.getLimit(), logRequest.isIncludeMergedRevisions(), logRequest.getRevisionProperties(), (ISVNLogEntryHandler)this);
        this.writeXMLFooter(null);
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        if (logEntry.getRevision() == -1L) {
            if (this.getDepth() == 0) {
                return;
            }
            this.decreaseDepth();
        }
        StringBuffer xmlBuffer = new StringBuffer();
        SVNXMLUtil.openXMLTag((String)"S", (String)"log-item", (int)1, null, (StringBuffer)xmlBuffer);
        SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.VERSION_NAME.getName(), (String)String.valueOf(logEntry.getRevision()), (StringBuffer)xmlBuffer);
        boolean noCustomProperties = this.getLogRequest().isCustomPropertyRequested();
        SVNProperties revProps = logEntry.getRevisionProperties();
        for (String string : revProps.nameSet()) {
            String propValue = revProps.getStringValue(string);
            if ("svn:author".equals(string)) {
                SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.CREATOR_DISPLAY_NAME.getName(), (String)propValue, null, (boolean)false, (boolean)true, (StringBuffer)xmlBuffer);
                continue;
            }
            if ("svn:date".equals(string)) {
                SVNXMLUtil.openCDataTag((String)"S", (String)"date", (String)propValue, null, (boolean)false, (boolean)true, (StringBuffer)xmlBuffer);
                continue;
            }
            if ("svn:log".equals(string)) {
                String comment = SVNEncodingUtil.fuzzyEscape((String)propValue);
                SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.COMMENT.getName(), (String)comment, null, (boolean)false, (boolean)true, (StringBuffer)xmlBuffer);
                continue;
            }
            noCustomProperties = false;
            String encodedPropName = SVNEncodingUtil.xmlEncodeCDATA((String)string, (boolean)false);
            SVNXMLUtil.openCDataTag((String)"S", (String)"revprop", (String)propValue, (String)"name", (String)encodedPropName, (boolean)false, (boolean)true, (StringBuffer)xmlBuffer);
        }
        if (noCustomProperties) {
            SVNXMLUtil.openXMLTag((String)"S", (String)"no-custom-revprops", (int)4, null, (StringBuffer)xmlBuffer);
        }
        if (logEntry.hasChildren()) {
            SVNXMLUtil.openXMLTag((String)"S", (String)"has-children", (int)4, null, (StringBuffer)xmlBuffer);
            this.increaseDepth();
        }
        this.write(xmlBuffer);
        if (logEntry.getChangedPaths() != null) {
            for (Map.Entry entry : logEntry.getChangedPaths().entrySet()) {
                String path = (String)entry.getKey();
                SVNLogEntryPath logEntryPath = (SVNLogEntryPath)entry.getValue();
                this.addChangedPathTag(path, logEntryPath);
            }
        }
        xmlBuffer = SVNXMLUtil.closeXMLTag((String)"S", (String)"log-item", null);
        this.write(xmlBuffer);
    }

    private void addChangedPathTag(String path, SVNLogEntryPath logEntryPath) throws SVNException {
        StringBuffer xmlBuffer = new StringBuffer();
        switch (logEntryPath.getType()) {
            case 'A': {
                if (logEntryPath.getCopyPath() != null && SVNRevision.isValidRevisionNumber((long)logEntryPath.getCopyRevision())) {
                    SVNHashMap attrs = new SVNHashMap();
                    attrs.put("copyfrom-path", logEntryPath.getCopyPath());
                    attrs.put("copyfrom-rev", String.valueOf(logEntryPath.getCopyRevision()));
                    SVNXMLUtil.openCDataTag((String)"S", (String)"added-path", (String)path, (Map)attrs, (StringBuffer)xmlBuffer);
                    break;
                }
                SVNXMLUtil.openCDataTag((String)"S", (String)"added-path", (String)path, (StringBuffer)xmlBuffer);
                break;
            }
            case 'R': {
                SVNHashMap attrs = null;
                if (logEntryPath.getCopyPath() != null && SVNRevision.isValidRevisionNumber((long)logEntryPath.getCopyRevision())) {
                    attrs = new SVNHashMap();
                    attrs.put("copyfrom-path", logEntryPath.getCopyPath());
                    attrs.put("copyfrom-rev", String.valueOf(logEntryPath.getCopyRevision()));
                }
                SVNXMLUtil.openCDataTag((String)"S", (String)"replaced-path", (String)path, attrs, (StringBuffer)xmlBuffer);
                break;
            }
            case 'M': {
                SVNXMLUtil.openCDataTag((String)"S", (String)"modified-path", (String)path, (StringBuffer)xmlBuffer);
                break;
            }
            case 'D': {
                SVNXMLUtil.openCDataTag((String)"S", (String)"deleted-path", (String)path, (StringBuffer)xmlBuffer);
                break;
            }
        }
        this.write(xmlBuffer);
    }
}

