/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVLogRequest
extends DAVRequest {
    private static final DAVElement DISCOVER_CHANGED_PATHS = DAVElement.getElement((String)"svn:", (String)"discover-changed-paths");
    private static final DAVElement INCLUDE_MERGED_REVISIONS = DAVElement.getElement((String)"svn:", (String)"include-merged-revisions");
    private static final DAVElement STRICT_NODE_HISTORY = DAVElement.getElement((String)"svn:", (String)"strict-node-history");
    private static final DAVElement OMIT_LOG_TEXT = DAVElement.getElement((String)"svn:", (String)"omit-log-text");
    private static final DAVElement LIMIT = DAVElement.getElement((String)"svn:", (String)"limit");
    private static final DAVElement ALL_REVPROPS = DAVElement.getElement((String)"svn:", (String)"all-revprops");
    private static final DAVElement REVPROP = DAVElement.getElement((String)"svn:", (String)"revprop");
    private static final String[] DEFAULT_REVISION_PROPERTIES = new String[]{"svn:author", "svn:date", "svn:log"};
    private boolean myDiscoverChangedPaths = false;
    private boolean myStrictNodeHistory = false;
    private boolean myIncludeMergedRevisions = false;
    private boolean myOmitLogText = false;
    private long myStartRevision = -1L;
    private long myEndRevision = -1L;
    private long myLimit = 0L;
    private Collection myTargetPathsCollection;
    private String[] myTargetPathsArray;
    private Collection myRevisionPropertiesCollection;
    private String[] myRevisionPropertiesArray;
    private boolean myCustomPropertyRequested = false;

    public boolean isDiscoverChangedPaths() {
        return this.myDiscoverChangedPaths;
    }

    private void setDiscoverChangedPaths(boolean discoverChangedPaths) {
        this.myDiscoverChangedPaths = discoverChangedPaths;
    }

    public boolean isStrictNodeHistory() {
        return this.myStrictNodeHistory;
    }

    private void setStrictNodeHistory(boolean strictNodeHistory) {
        this.myStrictNodeHistory = strictNodeHistory;
    }

    public boolean isIncludeMergedRevisions() {
        return this.myIncludeMergedRevisions;
    }

    private void setIncludeMergedRevisions(boolean includeMergedRevisions) {
        this.myIncludeMergedRevisions = includeMergedRevisions;
    }

    public boolean isOmitLogText() {
        return this.myOmitLogText;
    }

    private void setOmitLogText(boolean omitLogText) {
        this.myOmitLogText = omitLogText;
    }

    public long getStartRevision() {
        return this.myStartRevision;
    }

    private void setStartRevision(long startRevision) {
        this.myStartRevision = startRevision;
    }

    public long getEndRevision() {
        return this.myEndRevision;
    }

    private void setEndRevision(long endRevision) {
        this.myEndRevision = endRevision;
    }

    public long getLimit() {
        return this.myLimit;
    }

    private void setLimit(long limit) {
        this.myLimit = limit;
    }

    public String[] getTargetPaths() {
        if (this.myTargetPathsArray == null && this.myTargetPathsCollection != null) {
            this.myTargetPathsArray = this.myTargetPathsCollection.toArray(new String[this.myTargetPathsCollection.size()]);
        }
        return this.myTargetPathsArray;
    }

    private void addTargetPaths(Collection targetPaths) {
        if (this.myTargetPathsCollection == null) {
            this.myTargetPathsCollection = new LinkedList();
        }
        this.myTargetPathsCollection.addAll(targetPaths);
    }

    public String[] getRevisionProperties() {
        if (this.myRevisionPropertiesArray == null && this.myRevisionPropertiesCollection != null) {
            this.myRevisionPropertiesArray = this.myRevisionPropertiesCollection.toArray(new String[this.myRevisionPropertiesCollection.size()]);
        }
        return this.myRevisionPropertiesArray;
    }

    private void addRevisionProperties(Collection revisionProperties) {
        if (this.myRevisionPropertiesCollection == null) {
            this.myRevisionPropertiesCollection = new LinkedList();
        }
        this.myRevisionPropertiesCollection.addAll(revisionProperties);
    }

    private void setRevisionProperties(String[] revisionProperties) {
        this.myRevisionPropertiesArray = revisionProperties;
    }

    public boolean isCustomPropertyRequested() {
        return this.myCustomPropertyRequested;
    }

    private void setCustomPropertyRequested(boolean customPropertyRequested) {
        this.myCustomPropertyRequested = customPropertyRequested;
    }

    @Override
    protected void init() throws SVNException {
        boolean revisionPropertyRequested = false;
        List children = this.getRootElement().getChildren();
        for (DAVElementProperty property : children) {
            String revisionString;
            DAVElement element = property.getName();
            if (element == DISCOVER_CHANGED_PATHS) {
                this.setDiscoverChangedPaths(true);
                continue;
            }
            if (element == STRICT_NODE_HISTORY) {
                this.setStrictNodeHistory(true);
                continue;
            }
            if (element == INCLUDE_MERGED_REVISIONS) {
                this.setIncludeMergedRevisions(true);
                continue;
            }
            if (element == OMIT_LOG_TEXT) {
                this.setOmitLogText(true);
                continue;
            }
            if (element == DAVElement.START_REVISION) {
                revisionString = property.getFirstValue(true);
                try {
                    this.setStartRevision(Long.parseLong(revisionString));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (element == DAVElement.END_REVISION) {
                revisionString = property.getFirstValue(true);
                try {
                    this.setEndRevision(Long.parseLong(revisionString));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (element == LIMIT) {
                String limitString = property.getFirstValue(true);
                this.setLimit(Integer.parseInt(limitString));
                continue;
            }
            if (element == DAVElement.PATH) {
                Collection paths = property.getValues();
                if (paths == null) continue;
                this.addTargetPaths(paths);
                continue;
            }
            if (element == ALL_REVPROPS) {
                this.setCustomPropertyRequested(true);
                revisionPropertyRequested = true;
                continue;
            }
            if (element != REVPROP) continue;
            Collection properties = property.getValues();
            this.addRevisionProperties(properties);
            this.setCustomPropertyRequested(this.containsCustomProperty(properties));
            revisionPropertyRequested = true;
        }
        if (!revisionPropertyRequested) {
            this.setRevisionProperties(DEFAULT_REVISION_PROPERTIES);
        }
    }

    private boolean containsCustomProperty(Collection requestedProperties) {
        for (String property : requestedProperties) {
            if ("svn:author".equals(property) || "svn:date".equals(property) || "svn:log".equals(property)) continue;
            return true;
        }
        return false;
    }
}

