/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMergeRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVMergeHandler
extends ServletDAVHandler {
    private DAVMergeRequest myDAVRequest;

    protected DAVMergeHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    @Override
    public void execute() throws SVNException {
        DAVMergeRequest requestXMLObject;
        DAVElementProperty rootElement;
        DAVElementProperty sourceElement;
        long readLength = this.readInput(false);
        if (readLength <= 0L) {
            this.getMergeRequest().invalidXMLRoot();
        }
        if ((sourceElement = (rootElement = (requestXMLObject = this.getMergeRequest()).getRoot()).getChild(DAVElement.SOURCE)) == null) {
            throw new DAVException("The DAV:merge element must contain a DAV:source element.", 400, 0);
        }
        DAVElementProperty hrefElement = sourceElement.getChild(DAVElement.HREF);
        if (hrefElement == null) {
            throw new DAVException("The DAV:source element must contain a DAV:href element.", 400, 0);
        }
        String source = hrefElement.getFirstValue(false);
        URI uri = null;
        try {
            uri = DAVServletUtil.lookUpURI(source, this.getRequest(), false);
        }
        catch (DAVException dave) {
            if (dave.getResponseCode() == 400) {
                throw dave;
            }
            this.response(dave.getMessage(), DAVServlet.getStatusLine(dave.getResponseCode()), dave.getResponseCode());
        }
        String path = uri.getPath();
        DAVRepositoryManager manager = this.getRepositoryManager();
        String resourceContext = manager.getResourceContext();
        if (!path.startsWith(resourceContext)) {
            throw new DAVException("Destination url starts with a wrong context", 400, 0);
        }
        path = path.substring(resourceContext.length());
        DAVResource srcResource = this.getRequestedDAVResource(false, false, path);
        DAVResource resource = this.getRequestedDAVResource(false, false);
        if (!resource.exists()) {
            this.sendError(404, null);
            return;
        }
        this.setResponseHeader("Cache-Control", "no-cache");
        String response = null;
        try {
            response = this.merge(resource, srcResource);
        }
        catch (DAVException dave) {
            throw new DAVException("Could not MERGE resource \"{0}\" into \"{1}\".", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)source), SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, dave.getResponseCode(), null, SVNLogType.NETWORK, Level.FINE, dave, null, null, 0, null);
        }
        try {
            this.setResponseContentLength(response.getBytes("UTF-8").length);
        }
        catch (UnsupportedEncodingException dave) {
            // empty catch block
        }
        try {
            this.getResponseWriter().write(response);
        }
        catch (IOException ioe) {
            throw new DAVException(ioe.getMessage(), 500, SVNErrorCode.IO_ERROR.getCode());
        }
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getMergeRequest();
    }

    private String merge(DAVResource targetResource, DAVResource sourceResource) throws DAVException {
        SVNErrorMessage childErr;
        long newRev;
        String postCommitErrMessage;
        SVNErrorMessage[] postCommitHookErr;
        FSFS fsfs;
        Map locks;
        boolean disableMergeResponse;
        block16: {
            disableMergeResponse = false;
            if (sourceResource.getType() != DAVResourceType.ACTIVITY) {
                throw new DAVException("MERGE can only be performed using an activity as the source [at this time].", null, 405, null, SVNLogType.NETWORK, Level.FINE, null, "error", "svn:", SVNErrorCode.INCORRECT_PARAMS.getCode(), null);
            }
            locks = this.parseLocks(this.getMergeRequest().getRootElement(), targetResource.getResourceURI().getPath());
            if (!locks.isEmpty()) {
                sourceResource.setLockTokens(locks.values());
            }
            fsfs = sourceResource.getFSFS();
            String txnName = sourceResource.getTxnName();
            FSTransactionInfo txn = DAVServletUtil.openTxn(fsfs, txnName);
            FSTransactionRoot txnRoot = null;
            try {
                txnRoot = fsfs.createTransactionRoot(txn);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not open a (transaction) root in the repository", null);
            }
            FSCommitter committer = this.getCommitter(sourceResource.getFSFS(), (FSRoot)txnRoot, txn, sourceResource.getLockTokens(), sourceResource.getUserName());
            StringBuffer buffer = new StringBuffer();
            postCommitHookErr = new SVNErrorMessage[1];
            postCommitErrMessage = null;
            newRev = -1L;
            try {
                newRev = committer.commitTxn(true, true, postCommitHookErr, buffer);
            }
            catch (SVNException svne) {
                if (postCommitHookErr[0] != null) break block16;
                try {
                    FSCommitter.abortTransaction((FSFS)fsfs, (String)txnName);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_CONFLICT) {
                    throw DAVException.convertError(svne.getErrorMessage(), 409, "A conflict occurred during the MERGE processing. The problem occurred with the \"{0}\" resource.", new Object[]{buffer.toString()});
                }
                throw DAVException.convertError(svne.getErrorMessage(), 409, "An error occurred while committing the transaction.", null);
            }
        }
        if (postCommitHookErr[0] != null && (childErr = postCommitHookErr[0].getChildErrorMessage()) != null && childErr.getMessage() != null) {
            postCommitErrMessage = childErr.getMessage();
        }
        DAVServletUtil.storeActivity(sourceResource, "");
        String clientOptions = sourceResource.getClientOptions();
        if (clientOptions != null) {
            if (clientOptions.indexOf("release-locks") != -1 && !locks.isEmpty()) {
                for (String path : locks.keySet()) {
                    String lockToken = (String)locks.get(path);
                    try {
                        fsfs.unlockPath(path, lockToken, sourceResource.getUserName(), false, true);
                    }
                    catch (SVNException sVNException) {}
                }
            }
            if (clientOptions.indexOf("no-merge-response") != -1) {
                disableMergeResponse = true;
            }
        }
        return this.response(fsfs, newRev, postCommitErrMessage, disableMergeResponse);
    }

    private String response(FSFS fsfs, long newRev, String postCommitErr, boolean disableMergeResponse) throws DAVException {
        FSRevisionRoot root = null;
        try {
            root = fsfs.createRevisionRoot(newRev);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not open the FS root for the revision just committed.", null);
        }
        String vcc = DAVPathUtil.buildURI(this.getRepositoryManager().getResourceContext(), DAVResourceKind.VCC, -1L, null, false);
        StringBuffer buffer = new StringBuffer();
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        LinkedList<String> namespaces = new LinkedList<String>();
        namespaces.add("DAV:");
        prefixMap.put("DAV:", "D");
        String postCommitErrElement = null;
        if (postCommitErr != null) {
            namespaces.add("svn:");
            prefixMap.put("svn:", "S");
            SVNXMLUtil.openXMLTag((String)"S", (String)DAVElement.POST_COMMIT_ERROR.getName(), (int)2, null, (StringBuffer)buffer);
            buffer.append(postCommitErr);
            SVNXMLUtil.closeXMLTag((String)"S", (String)DAVElement.POST_COMMIT_ERROR.getName(), (StringBuffer)buffer);
            postCommitErrElement = buffer.toString();
            buffer.delete(0, buffer.length());
        } else {
            postCommitErrElement = "";
        }
        String creationDate = null;
        String creatorDisplayName = null;
        try {
            SVNProperties revProps = fsfs.getRevisionProperties(newRev);
            creationDate = revProps.getStringValue("svn:date");
            creatorDisplayName = revProps.getStringValue("svn:author");
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not get author of newest revision", null);
        }
        SVNXMLUtil.addXMLHeader((StringBuffer)buffer);
        SVNXMLUtil.openNamespaceDeclarationTag((String)"D", (String)DAVElement.MERGE_RESPONSE.getName(), namespaces, prefixMap, null, (StringBuffer)buffer, (boolean)true);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.UPDATE_SET.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.RESPONSE.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.HREF.getName(), (String)vcc, null, (boolean)true, (boolean)true, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.RESOURCE_TYPE.getName(), (int)2, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.BASELINE.getName(), (int)6, null, (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.RESOURCE_TYPE.getName(), (StringBuffer)buffer);
        buffer.append(postCommitErrElement);
        buffer.append('\n');
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.VERSION_NAME.getName(), (int)2, null, (StringBuffer)buffer);
        buffer.append(newRev);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.VERSION_NAME.getName(), (StringBuffer)buffer);
        if (creationDate != null) {
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.CREATION_DATE.getName(), (String)creationDate, null, (boolean)true, (boolean)true, (StringBuffer)buffer);
        }
        if (creatorDisplayName != null) {
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.CREATOR_DISPLAY_NAME.getName(), (String)creatorDisplayName, null, (boolean)true, (boolean)true, (StringBuffer)buffer);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (int)2, null, (StringBuffer)buffer);
        buffer.append("HTTP/1.1 200 OK");
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.RESPONSE.getName(), (StringBuffer)buffer);
        if (!disableMergeResponse) {
            try {
                this.doResources(root, buffer);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Error constructing resource list.", null);
            }
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.UPDATE_SET.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.MERGE_RESPONSE.getName(), (StringBuffer)buffer);
        return buffer.toString();
    }

    private void doResources(FSRevisionRoot root, StringBuffer buffer) throws SVNException {
        Map changedPaths = root.getChangedPaths();
        HashMap<String, String> sentPaths = new HashMap<String, String>();
        for (String path : changedPaths.keySet()) {
            String parentPath;
            FSPathChange pathChange = (FSPathChange)changedPaths.get(path);
            boolean sendSelf = false;
            boolean sendParent = false;
            FSPathChangeKind changeKind = pathChange.getChangeKind();
            if (changeKind == FSPathChangeKind.FS_PATH_CHANGE_DELETE) {
                sendSelf = false;
                sendParent = true;
            } else if (changeKind == FSPathChangeKind.FS_PATH_CHANGE_ADD || changeKind == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
                sendSelf = true;
                sendParent = true;
            } else {
                sendSelf = true;
                sendParent = false;
            }
            if (sendSelf && !sentPaths.containsKey(path)) {
                SVNNodeKind pathKind = root.checkNodeKind(path);
                this.sendResponse(root, path, pathKind == SVNNodeKind.DIR, buffer);
                sentPaths.put(path, path);
            }
            if (!sendParent || sentPaths.containsKey(parentPath = SVNPathUtil.removeTail((String)path))) continue;
            this.sendResponse(root, parentPath, true, buffer);
            sentPaths.put(parentPath, parentPath);
        }
    }

    private void sendResponse(FSRevisionRoot root, String path, boolean isDir, StringBuffer buffer) {
        String context = this.getRepositoryManager().getResourceContext();
        String href = DAVPathUtil.buildURI(context, DAVResourceKind.PUBLIC, -1L, path, false);
        long revToUse = DAVServletUtil.getSafeCreatedRevision(root, path);
        String vsnURL = DAVPathUtil.buildURI(context, DAVResourceKind.VERSION, revToUse, path, false);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.RESPONSE.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.HREF.getName(), (String)href, null, (boolean)true, (boolean)true, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)2, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)1, null, (StringBuffer)buffer);
        if (isDir) {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.RESOURCE_TYPE.getName(), (int)2, null, (StringBuffer)buffer);
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.COLLECTION.getName(), (int)6, null, (StringBuffer)buffer);
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.RESOURCE_TYPE.getName(), (StringBuffer)buffer);
        } else {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.RESOURCE_TYPE.getName(), (int)5, null, (StringBuffer)buffer);
        }
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.CHECKED_IN.getName(), (int)2, null, (StringBuffer)buffer);
        SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.HREF.getName(), (String)vsnURL, null, (boolean)true, (boolean)true, (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.CHECKED_IN.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (int)2, null, (StringBuffer)buffer);
        buffer.append("HTTP/1.1 200 OK");
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.RESPONSE.getName(), (StringBuffer)buffer);
    }

    private DAVMergeRequest getMergeRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVMergeRequest();
        }
        return this.myDAVRequest;
    }
}

