/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.server.dav.DAVConfig;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DAVPropertiesProvider {
    private boolean myIsDeferred;
    private boolean myIsOperative;
    private DAVResource myResource;
    private ServletDAVHandler myOwner;
    private SVNProperties myProperties;

    private DAVPropertiesProvider(boolean isDeferred, ServletDAVHandler owner, DAVResource resource) {
        this.myIsDeferred = isDeferred;
        this.myOwner = owner;
        this.myResource = resource;
    }

    public static DAVPropertiesProvider createPropertiesProvider(DAVResource resource, ServletDAVHandler owner) throws DAVException {
        DAVResourceURI resourceURI = resource.getResourceURI();
        if (resourceURI.getURI() == null) {
            throw new DAVException("INTERNAL DESIGN ERROR: resource must define its URI.", 500, 0);
        }
        DAVPropertiesProvider provider = new DAVPropertiesProvider(true, owner, resource);
        return provider;
    }

    public void open(boolean readOnly) throws DAVException {
        this.myIsDeferred = false;
        try {
            this.doOpen(readOnly);
        }
        catch (DAVException dave) {
            throw new DAVException("Could not open the property database.", 500, 205);
        }
    }

    public void applyRollBack(DAVElement propName, SVNPropertyValue propValue) throws DAVException {
        if (propValue == null) {
            this.removeProperty(propName);
            return;
        }
        this.saveValue(propName, propValue);
    }

    public void removeProperty(DAVElement propName) throws DAVException {
        String reposPropName = this.getReposPropName(propName);
        if (reposPropName == null) {
            return;
        }
        try {
            FSFS fsfs = this.myResource.getFSFS();
            if (this.myResource.isBaseLined()) {
                if (this.myResource.isWorking()) {
                    FSTransactionInfo txn = this.myResource.getTxnInfo();
                    SVNProperties props = new SVNProperties();
                    props.put(reposPropName, (SVNPropertyValue)null);
                    fsfs.changeTransactionProperties(txn.getTxnId(), props);
                } else {
                    SVNRepository repos = this.myResource.getRepository();
                    repos.setRevisionPropertyValue(this.myResource.getRevision(), reposPropName, null);
                }
            } else {
                DAVResourceURI resourceURI = this.myResource.getResourceURI();
                FSCommitter committer = this.getCommitter();
                committer.changeNodeProperty(resourceURI.getPath(), reposPropName, null);
            }
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "could not remove a property", null);
        }
        this.myProperties = null;
    }

    public void storeProperty(DAVElementProperty property) throws DAVException {
        DAVElement propName = property.getName();
        String propValue = property.getFirstValue(false);
        String reposPropName = this.getReposPropName(propName);
        SVNPropertyValue value = null;
        Map attributes = property.getAttributes();
        if (attributes != null) {
            for (String attrName : attributes.keySet()) {
                if (!"encoding".equals(attrName)) continue;
                String encodingType = (String)attributes.get(attrName);
                if ("base64".equals(encodingType)) {
                    byte[] buffer = new byte[propValue.length()];
                    int length = SVNBase64.base64ToByteArray((StringBuffer)new StringBuffer(propValue), (byte[])buffer);
                    value = SVNPropertyValue.create((String)reposPropName, (byte[])buffer, (int)0, (int)length);
                    break;
                }
                throw new DAVException("Unknown property encoding", 500, 0);
            }
        }
        if (value == null) {
            value = SVNPropertyValue.create((String)propValue);
        }
        this.saveValue(propName, value);
    }

    public void defineNamespaces(Map namespaces) {
        namespaces.put("http://subversion.tigris.org/xmlns/svn/", "S");
        namespaces.put("http://subversion.tigris.org/xmlns/custom/", "C");
        namespaces.put("http://subversion.tigris.org/xmlns/dav/", "V");
    }

    public Collection getPropertyNames() throws DAVException {
        FSFS fsfs = this.myResource.getFSFS();
        SVNException exc = null;
        if (this.myProperties == null) {
            if (this.myResource.isBaseLined()) {
                if (this.myResource.getType() == DAVResourceType.WORKING) {
                    try {
                        this.myProperties = fsfs.getTransactionProperties(this.myResource.getTxnName());
                    }
                    catch (SVNException svne) {
                        exc = svne;
                    }
                } else {
                    try {
                        this.myProperties = fsfs.getRevisionProperties(this.myResource.getRevision());
                    }
                    catch (SVNException svne) {
                        exc = svne;
                    }
                }
            } else {
                FSRoot root = this.myResource.getRoot();
                String path = this.myResource.getResourceURI().getPath();
                try {
                    FSRevisionNode node = root.getRevisionNode(path);
                    this.myProperties = node.getProperties(fsfs);
                }
                catch (SVNException svne) {
                    exc = svne;
                }
                if (exc == null) {
                    try {
                        root.checkNodeKind(path);
                    }
                    catch (SVNException svne) {
                        exc = svne;
                    }
                }
            }
            if (exc != null) {
                throw DAVException.convertError(exc.getErrorMessage(), 500, "could not begin sequencing through properties", null);
            }
        }
        ArrayList<DAVElement> propNames = new ArrayList<DAVElement>();
        for (String propName : this.myProperties.nameSet()) {
            DAVElement propElementName = null;
            propElementName = propName.startsWith("svn:") ? DAVElement.getElement((String)"http://subversion.tigris.org/xmlns/svn/", (String)propName.substring("svn:".length())) : DAVElement.getElement((String)"http://subversion.tigris.org/xmlns/custom/", (String)propName);
            propNames.add(propElementName);
        }
        return propNames;
    }

    public boolean outputValue(DAVElement propName, StringBuffer buffer) throws DAVException {
        boolean found;
        SVNPropertyValue propValue = this.getPropertyValue(propName);
        boolean bl = found = propValue != null;
        if (!found) {
            return found;
        }
        String prefix = null;
        prefix = "http://subversion.tigris.org/xmlns/custom/".equals(propName.getNamespace()) ? "C" : "S";
        String propValueString = SVNPropertyValue.getPropertyAsString((SVNPropertyValue)propValue);
        if ("".equals(propValueString)) {
            SVNXMLUtil.openXMLTag((String)prefix, (String)propName.getName(), (int)4, null, (StringBuffer)buffer);
        } else {
            String xmlSafeValue = null;
            HashMap<String, String> attrs = null;
            if (!SVNEncodingUtil.isXMLSafe((String)propValueString)) {
                try {
                    xmlSafeValue = SVNBase64.byteArrayToBase64((byte[])propValueString.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    xmlSafeValue = SVNBase64.byteArrayToBase64((byte[])propValueString.getBytes());
                }
                attrs = new HashMap<String, String>();
                attrs.put("V:encoding", "base64");
            } else {
                xmlSafeValue = SVNEncodingUtil.xmlEncodeCDATA((String)propValueString);
            }
            SVNXMLUtil.openXMLTag((String)prefix, (String)propName.getName(), (int)2, attrs, (StringBuffer)buffer);
            buffer.append(xmlSafeValue);
            SVNXMLUtil.closeXMLTag((String)prefix, (String)propName.getName(), (StringBuffer)buffer);
        }
        return found;
    }

    public SVNPropertyValue getPropertyValue(DAVElement propName) throws DAVException {
        String reposPropName = this.getReposPropName(propName);
        if (reposPropName == null) {
            return null;
        }
        SVNProperties props = null;
        FSFS fsfs = this.myResource.getFSFS();
        try {
            if (this.myResource.isBaseLined()) {
                if (this.myResource.getType() == DAVResourceType.WORKING) {
                    FSTransactionInfo txn = this.myResource.getTxnInfo();
                    props = fsfs.getTransactionProperties(txn.getTxnId());
                } else {
                    long revision = this.myResource.getRevision();
                    props = fsfs.getRevisionProperties(revision);
                }
            } else {
                FSRoot root = this.myResource.getRoot();
                props = fsfs.getProperties(root.getRevisionNode(this.myResource.getResourceURI().getPath()));
            }
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "could not fetch a property", null);
        }
        if (props != null) {
            return props.getSVNPropertyValue(reposPropName);
        }
        return null;
    }

    public DAVResource getResource() {
        return this.myResource;
    }

    private void saveValue(DAVElement propName, SVNPropertyValue value) throws DAVException {
        String reposPropName = this.getReposPropName(propName);
        if (reposPropName == null) {
            DAVConfig config = this.myResource.getRepositoryManager().getDAVConfig();
            if (config.isAutoVersioning()) {
                reposPropName = propName.getName();
            } else {
                throw new DAVException("Properties may only be defined in the {0} and {1} namespaces.", new Object[]{"http://subversion.tigris.org/xmlns/svn/", "http://subversion.tigris.org/xmlns/custom/"}, 409, 0);
            }
        }
        try {
            FSFS fsfs = this.myResource.getFSFS();
            if (this.myResource.isBaseLined()) {
                if (this.myResource.isWorking()) {
                    FSTransactionInfo txn = this.myResource.getTxnInfo();
                    SVNProperties props = new SVNProperties();
                    props.put(reposPropName, value);
                    fsfs.changeTransactionProperties(txn.getTxnId(), props);
                } else {
                    SVNRepository repos = this.myResource.getRepository();
                    repos.setRevisionPropertyValue(this.myResource.getRevision(), reposPropName, value);
                }
            } else {
                DAVResourceURI resourceURI = this.myResource.getResourceURI();
                FSCommitter committer = this.getCommitter();
                committer.changeNodeProperty(resourceURI.getPath(), reposPropName, value);
            }
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, null, null);
        }
        this.myProperties = null;
    }

    private String getReposPropName(DAVElement propName) {
        if ("http://subversion.tigris.org/xmlns/svn/".equals(propName.getNamespace())) {
            return "svn:" + propName.getName();
        }
        if ("http://subversion.tigris.org/xmlns/custom/".equals(propName.getNamespace())) {
            return propName.getName();
        }
        return null;
    }

    public boolean isOperative() {
        return this.myIsOperative;
    }

    public boolean isDeferred() {
        return this.myIsDeferred;
    }

    public void setDeferred(boolean isDeferred) {
        this.myIsDeferred = isDeferred;
    }

    private void doOpen(boolean readOnly) throws DAVException {
        this.myIsOperative = true;
        DAVResourceType resType = this.myResource.getType();
        if (resType == DAVResourceType.HISTORY || resType == DAVResourceType.ACTIVITY || resType == DAVResourceType.PRIVATE) {
            this.myIsOperative = false;
            return;
        }
        if (!(readOnly || resType == DAVResourceType.WORKING || this.myResource.isBaseLined() && resType == DAVResourceType.VERSION)) {
            throw new DAVException("Properties may only be changed on working resources.", 409, 0);
        }
    }

    private FSCommitter getCommitter() {
        return this.myOwner.getCommitter(this.myResource.getFSFS(), this.myResource.getRoot(), this.myResource.getTxnInfo(), this.myResource.getLockTokens(), this.myResource.getUserName());
    }
}

