/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVBase64OutputStream;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVDatedRevisionHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVFileRevisionsHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetDeletedRevisionHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocationSegmentsHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocationsHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocksHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLogHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMergeInfoHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReplayHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVUpdateHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVReportHandler
extends ServletDAVHandler {
    protected static final Set REPORT_NAMESPACES = new SVNHashSet();
    protected static final String PATH_ATTR = "path";
    protected static final String REVISION_ATTR = "rev";
    protected static final String COPYFROM_PATH_ATTR = "copyfrom-path";
    protected static final String COPYFROM_REVISION_ATTR = "copyfrom-rev";
    protected static final String TXDELTA_ATTR = "txdelta";
    protected static final String CHECKSUM_ATTR = "checksum";
    protected static final String DELETE_ATTR = "del";
    protected static final String LOCK_TOKEN_ATTR = "lock-token";
    protected static final String LINKPATH_ATTR = "linkpath";
    protected static final String DEPTH_ATTR = "depth";
    protected static final String START_EMPTY_ATTR = "start-empty";
    protected static final String SEND_ALL_ATTR = "send-all";
    protected static final String BASE_CHECKSUM_ATTR = "base-checksum";
    protected static final String BC_URL_ATTR = "bc-url";
    private DAVRepositoryManager myRepositoryManager;
    private HttpServletRequest myRequest;
    private HttpServletResponse myResponse;
    private DAVReportHandler myReportHandler;
    private DAVResource myDAVResource;
    private OutputStream myDiffWindowWriter;
    private boolean myWriteTextDeltaHeader = true;
    private boolean mySVNDiffVersion = false;
    private boolean myIsUnknownReport;

    protected DAVReportHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
        this.myRepositoryManager = connector;
        this.myRequest = request;
        this.myResponse = response;
    }

    protected List getNamespaces() {
        return super.getNamespaces();
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getReportHandler().getDAVRequest();
    }

    private DAVReportHandler getReportHandler() {
        return this.myReportHandler;
    }

    private void setReportHandler(DAVReportHandler reportHandler) {
        this.myReportHandler = reportHandler;
    }

    protected DAVResource getDAVResource() {
        return this.myDAVResource;
    }

    protected void setDAVResource(DAVResource DAVResource2) {
        this.myDAVResource = DAVResource2;
    }

    protected void checkSVNNamespace(String errorMessage) throws DAVException {
        errorMessage = errorMessage == null ? "The request does not contain the 'svn:' namespace, so it is not going to have certain required elements." : errorMessage;
        List namespaces = this.getNamespaces();
        if (!namespaces.contains("svn:")) {
            throw new DAVException(errorMessage, 400, SVNLogType.NETWORK, "error", "svn:");
        }
    }

    public boolean doCompress() {
        return this.mySVNDiffVersion;
    }

    public void setSVNDiffVersion(boolean SVNDiffVersion) {
        this.mySVNDiffVersion = SVNDiffVersion;
    }

    private boolean isWriteTextDeltaHeader() {
        return this.myWriteTextDeltaHeader;
    }

    protected void setWriteTextDeltaHeader(boolean writeTextDeltaHeader) {
        this.myWriteTextDeltaHeader = writeTextDeltaHeader;
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (parent == null) {
            this.initReportHandler(element);
        }
        this.getReportHandler().handleAttributes(parent, element, attrs);
    }

    protected void handleAttributes(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        this.getDAVRequest().startElement(parent, element, attrs);
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        this.getReportHandler().handleCData(parent, element, cdata);
    }

    protected void handleCData(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        this.getDAVRequest().endElement(parent, element, cdata);
    }

    @Override
    public void execute() throws SVNException {
        long read = this.readInput(false);
        if (this.myIsUnknownReport) {
            throw new DAVException("The requested report is unknown.", null, 501, null, SVNLogType.DEFAULT, Level.FINE, null, "error", "svn:", SVNErrorCode.UNSUPPORTED_FEATURE.getCode(), null);
        }
        if (read == 0L) {
            throw new DAVException("The request body must specify a report.", 400, SVNLogType.NETWORK);
        }
        this.setDefaultResponseHeaders();
        this.setResponseContentType("text/xml; charset=\"utf-8\"");
        this.setResponseStatus(200);
        this.getReportHandler().execute();
    }

    private void initReportHandler(DAVElement rootElement) {
        this.myIsUnknownReport = false;
        if (rootElement == DATED_REVISIONS_REPORT) {
            this.setReportHandler(new DAVDatedRevisionHandler(this.myRepositoryManager, this.myRequest, this.myResponse));
        } else if (rootElement == FILE_REVISIONS_REPORT) {
            this.setReportHandler(new DAVFileRevisionsHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == GET_LOCATIONS) {
            this.setReportHandler(new DAVGetLocationsHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == LOG_REPORT) {
            this.setReportHandler(new DAVLogHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == MERGEINFO_REPORT) {
            this.setReportHandler(new DAVMergeInfoHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == GET_LOCKS_REPORT) {
            this.setReportHandler(new DAVGetLocksHandler(this.myRepositoryManager, this.myRequest, this.myResponse));
        } else if (rootElement == REPLAY_REPORT) {
            this.setReportHandler(new DAVReplayHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == UPDATE_REPORT) {
            this.setReportHandler(new DAVUpdateHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == GET_LOCATION_SEGMENTS) {
            this.setReportHandler(new DAVGetLocationSegmentsHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == GET_DELETED_REVISION_REPORT) {
            this.setReportHandler(new DAVGetDeletedRevisionHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else {
            this.myIsUnknownReport = true;
            this.setReportHandler(new DumpReportHandler(this.myRepositoryManager, this.myRequest, this.myResponse));
        }
    }

    protected void write(String string) throws SVNException {
        try {
            this.getResponseWriter().write(string);
        }
        catch (IOException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)e), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
        }
    }

    protected void write(StringBuffer stringBuffer) throws SVNException {
        this.write(stringBuffer.toString());
    }

    protected void writeXMLHeader(String tagName) throws SVNException {
        StringBuffer xmlBuffer = new StringBuffer();
        this.addXMLHeader(xmlBuffer, tagName);
        this.write(xmlBuffer);
    }

    protected void writeXMLFooter(String tagName) throws SVNException {
        StringBuffer xmlBuffer = new StringBuffer();
        this.addXMLFooter(xmlBuffer, tagName);
        this.write(xmlBuffer);
    }

    protected void addXMLHeader(StringBuffer xmlBuffer, String tagName) {
        SVNXMLUtil.addXMLHeader((StringBuffer)xmlBuffer);
        DAVElementProperty rootElement = this.getDAVRequest().getRootElement();
        tagName = tagName == null ? rootElement.getName().getName() : tagName;
        DAVXMLUtil.openNamespaceDeclarationTag("S", tagName, REPORT_NAMESPACES, xmlBuffer, false);
    }

    protected void addXMLFooter(StringBuffer xmlBuffer, String tagName) {
        DAVElementProperty rootElement = this.getDAVRequest().getRootElement();
        tagName = tagName == null ? rootElement.getName().getName() : tagName;
        SVNXMLUtil.closeXMLTag((String)"S", (String)tagName, (StringBuffer)xmlBuffer);
    }

    protected void writeTextDeltaChunk(SVNDiffWindow diffWindow) throws SVNException {
        if (this.myDiffWindowWriter == null) {
            this.myDiffWindowWriter = new DAVBase64OutputStream(this.getResponseWriter());
        }
        try {
            diffWindow.writeTo(this.myDiffWindowWriter, this.isWriteTextDeltaHeader(), this.doCompress());
        }
        catch (IOException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)e), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
        }
        finally {
            this.setWriteTextDeltaHeader(false);
        }
    }

    protected void textDeltaChunkEnd() throws SVNException {
        if (this.myDiffWindowWriter != null) {
            try {
                this.myDiffWindowWriter.flush();
            }
            catch (IOException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)e), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
            }
        }
        this.myDiffWindowWriter = null;
    }

    protected void writePropertyTag(String tagName, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (propertyValue == null) {
            StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)4, (String)"name", (String)propertyName, null);
            this.write(xmlBuffer);
            return;
        }
        String value = propertyValue.getString();
        boolean isXMLSafe = true;
        if (propertyValue.isBinary()) {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                value = decoder.decode(ByteBuffer.wrap(propertyValue.getBytes())).toString();
            }
            catch (CharacterCodingException e) {
                isXMLSafe = false;
            }
        }
        if (value != null) {
            isXMLSafe = SVNEncodingUtil.isXMLSafe((String)value);
        }
        if (!isXMLSafe) {
            byte[] buffer = null;
            if (value != null) {
                try {
                    buffer = value.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    buffer = value.getBytes();
                }
            } else {
                buffer = propertyValue.getBytes();
            }
            value = SVNBase64.byteArrayToBase64((byte[])buffer);
            SVNHashMap attrs = new SVNHashMap();
            attrs.put("name", propertyName);
            attrs.put("encoding", "base64");
            StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)2, (Map)attrs, null);
            this.write(xmlBuffer);
            this.write(value);
            xmlBuffer = SVNXMLUtil.closeXMLTag((String)"S", (String)tagName, null);
            this.write(xmlBuffer);
        } else {
            StringBuffer xmlBuffer = SVNXMLUtil.openCDataTag((String)"S", (String)tagName, (String)propertyValue.getString(), (String)"name", (String)propertyName, null);
            this.write(xmlBuffer);
        }
    }

    static {
        REPORT_NAMESPACES.add("svn:");
    }

    private static class DumpReportHandler
    extends DAVReportHandler {
        private DAVRequest myDAVRequest;

        protected DumpReportHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
            super(connector, request, response);
        }

        @Override
        protected DAVRequest getDAVRequest() {
            if (this.myDAVRequest == null) {
                this.myDAVRequest = new DAVRequest(){

                    @Override
                    protected void init() throws SVNException {
                    }
                };
            }
            return this.myDAVRequest;
        }
    }
}

