/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers;

import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.user.AuthUser;
import com.feth.play.module.pa.user.SessionAuthUser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.Application;
import play.Configuration;
import play.Logger;
import play.Plugin;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class AuthProvider
extends Plugin {
    private Application application;

    public AuthProvider(Application app) {
        this.application = app;
    }

    protected Application getApplication() {
        return this.application;
    }

    public void onStart() {
        List<String> neededSettings = this.neededSettingKeys();
        if (neededSettings != null) {
            Configuration c = this.getConfiguration();
            if (c == null) {
                throw new RuntimeException("No settings for provider '" + this.getKey() + "' available at all!");
            }
            for (String key : neededSettings) {
                String setting = c.getString(key);
                if (setting != null && !"".equals(setting)) continue;
                throw new RuntimeException("Provider '" + this.getKey() + "' missing needed setting '" + key + "'");
            }
        }
        Registry.register(this.getKey(), this);
        Logger.debug((String)("Registered AuthProvider '" + this.getKey() + "'"));
    }

    public void onStop() {
        Registry.unregister(this.getKey());
    }

    public String getUrl() {
        return PlayAuthenticate.getResolver().auth(this.getKey()).url();
    }

    protected String getAbsoluteUrl(Http.Request request) {
        return PlayAuthenticate.getResolver().auth(this.getKey()).absoluteURL(request);
    }

    public abstract String getKey();

    protected Configuration getConfiguration() {
        return PlayAuthenticate.getConfiguration().getConfig(this.getKey());
    }

    public abstract Object authenticate(Http.Context var1, Object var2) throws AuthException;

    protected List<String> neededSettingKeys() {
        return null;
    }

    public AuthUser getSessionAuthUser(String id, long expires) {
        return new SessionAuthUser(this.getKey(), id, expires);
    }

    public abstract boolean isExternal();

    public void afterSave(AuthUser user, Object identity, Http.Session session) {
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class Registry {
        private static Map<String, AuthProvider> providers = new HashMap<String, AuthProvider>();

        public static void register(String provider, AuthProvider p) {
            AuthProvider previous = providers.put(provider, p);
            if (previous != null) {
                Logger.warn((String)("There are multiple AuthProviders registered for key '" + provider + "'"));
            }
        }

        public static void unregister(String provider) {
            providers.remove(provider);
        }

        public static AuthProvider get(String provider) {
            return providers.get(provider);
        }

        public static Collection<AuthProvider> getProviders() {
            return providers.values();
        }

        public static boolean hasProvider(String provider) {
            return providers.containsKey(provider);
        }
    }
}

