/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth1.linkedin;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessDeniedException;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth1.OAuth1AuthProvider;
import com.feth.play.module.pa.providers.oauth1.linkedin.LinkedinAuthInfo;
import com.feth.play.module.pa.providers.oauth1.linkedin.LinkedinAuthUser;
import java.util.List;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.oauth.OAuth;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LinkedinAuthProvider
extends OAuth1AuthProvider<LinkedinAuthUser, LinkedinAuthInfo> {
    public static final String PROVIDER_KEY = "linkedin";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String USER_EMAIL_URL_SETTING_KEY = "userEmailUrl";
    public static final String OAUTH_ACCESS_DENIED = "user_refused";

    public LinkedinAuthProvider(Application app) {
        super(app);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected List<String> neededSettingKeys() {
        List<String> neededSettingKeys = super.neededSettingKeys();
        neededSettingKeys.add(USER_INFO_URL_SETTING_KEY);
        neededSettingKeys.add(USER_EMAIL_URL_SETTING_KEY);
        return neededSettingKeys;
    }

    @Override
    protected LinkedinAuthUser transform(LinkedinAuthInfo info) throws AuthException {
        String userInfoUrl = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        String emailUrl = this.getConfiguration().getString(USER_EMAIL_URL_SETTING_KEY);
        OAuth.OAuthCalculator op = this.getOAuthCalculator(info);
        JsonNode userJson = this.signedOauthGet(userInfoUrl, op);
        JsonNode emailJson = this.signedOauthGet(emailUrl, op);
        return new LinkedinAuthUser(userJson, emailJson.asText(), info);
    }

    @Override
    protected LinkedinAuthInfo buildInfo(OAuth.RequestToken requestToken) throws AccessTokenException {
        return new LinkedinAuthInfo(requestToken.token, requestToken.secret);
    }

    @Override
    protected void checkError(Http.Request request) throws AuthException {
        String error = request.getQueryString("oauth_problem");
        if (error != null) {
            if (error.equals(OAUTH_ACCESS_DENIED)) {
                throw new AccessDeniedException(this.getKey());
            }
            throw new AuthException(error);
        }
    }
}

