/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.openid;

import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.ext.ExternalAuthProvider;
import com.feth.play.module.pa.providers.openid.OpenIdAuthUser;
import com.feth.play.module.pa.providers.openid.exceptions.NoOpenIdAuthException;
import com.feth.play.module.pa.providers.openid.exceptions.OpenIdConnectException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import play.Application;
import play.Configuration;
import play.Logger;
import play.api.libs.openid.OpenIDError;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.openid.OpenID;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OpenIdAuthProvider
extends ExternalAuthProvider {
    public OpenIdAuthProvider(Application app) {
        super(app);
    }

    @Override
    public String getKey() {
        return "openid";
    }

    @Override
    public Object authenticate(Http.Context context, Object payload) throws AuthException {
        boolean hasOpenID;
        Http.Request request = context.request();
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)("Returned with URL: '" + request.uri() + "'"));
        }
        boolean bl = hasOpenID = payload != null && !payload.toString().trim().isEmpty();
        if (!hasOpenID) {
            try {
                F.Promise pu = OpenID.verifiedId();
                return new OpenIdAuthUser((OpenID.UserInfo)pu.get(this.getTimeout()));
            }
            catch (Throwable t) {
                if (t instanceof OpenIDError) {
                    if (!hasOpenID) {
                        throw new NoOpenIdAuthException("OpenID endpoint is required");
                    }
                    if (((OpenIDError)t).message() != null) {
                        throw new AuthException(((OpenIDError)t).message());
                    }
                    throw new AuthException("Bad response from OpenID provider");
                }
                throw new AuthException(t.getMessage());
            }
        }
        Map<String, String> required = this.getAttributes("required");
        Map<String, String> optional = this.getAttributes("optional");
        try {
            F.Promise pr = OpenID.redirectURL((String)payload.toString(), (String)this.getRedirectUrl(context.request()), required, optional);
            return pr.get(this.getTimeout());
        }
        catch (Throwable t) {
            if (t instanceof ConnectException) {
                throw new OpenIdConnectException(t.getMessage());
            }
            throw new AuthException(t.getMessage());
        }
    }

    private Map<String, String> getAttributes(String subKey) {
        Configuration attributes = this.getConfiguration().getConfig("attributes." + subKey);
        if (attributes != null) {
            Set keys = attributes.keys();
            HashMap<String, String> ret = new HashMap<String, String>(keys.size());
            for (String key : keys) {
                ret.put(key, attributes.getString(key));
            }
            return ret;
        }
        return null;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static abstract class SettingKeys {
        public static final String PROVIDER_KEY = "openid";
        public static final String ATTRIBUTES = "attributes";
        public static final String ATTRIBUTES_REQUIRED = "required";
        public static final String ATTRIBUTES_OPTIONAL = "optional";

        SettingKeys() {
        }
    }
}

