/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.password;

import akka.actor.Cancellable;
import com.feth.play.module.mail.Mailer;
import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.AuthProvider;
import com.feth.play.module.pa.providers.password.SessionUsernamePasswordAuthUser;
import com.feth.play.module.pa.providers.password.UsernamePasswordAuthUser;
import com.feth.play.module.pa.user.AuthUser;
import com.feth.play.module.pa.user.NameIdentity;
import java.util.Arrays;
import java.util.List;
import play.Application;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.mvc.Call;
import play.mvc.Http;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class UsernamePasswordAuthProvider<R, UL extends UsernamePasswordAuthUser, US extends UsernamePasswordAuthUser, L extends UsernamePassword, S extends UsernamePassword>
extends AuthProvider {
    public static final String PROVIDER_KEY = "password";
    protected static final String SETTING_KEY_MAIL = "mail";
    private static final String SETTING_KEY_MAIL_FROM_EMAIL = "email";
    private static final String SETTING_KEY_MAIL_DELAY = "delay";
    private static final String SETTING_KEY_MAIL_FROM = "from";
    protected Mailer mailer;

    @Override
    protected List<String> neededSettingKeys() {
        return Arrays.asList("mail.delay", "mail.from.email");
    }

    public UsernamePasswordAuthProvider(Application app) {
        super(app);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mailer = Mailer.getCustomMailer((Configuration)this.getConfiguration().getConfig(SETTING_KEY_MAIL));
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    public Object authenticate(Http.Context context, Object payload) throws AuthException {
        if (payload == Case.SIGNUP) {
            S signup = this.getSignup(context);
            US authUser = this.buildSignupAuthUser(signup, context);
            SignupResult r = this.signupUser(authUser);
            switch (r) {
                case USER_EXISTS: {
                    return this.userExists((UsernamePasswordAuthUser)authUser).url();
                }
                case USER_EXISTS_UNVERIFIED: 
                case USER_CREATED_UNVERIFIED: {
                    this.sendVerifyEmailMailing(context, authUser);
                    return this.userUnverified((UsernamePasswordAuthUser)authUser).url();
                }
                case USER_CREATED: {
                    return this.transformAuthUser(authUser, context);
                }
            }
            throw new AuthException("Something in signup went wrong");
        }
        if (payload == Case.LOGIN) {
            L login = this.getLogin(context);
            UL authUser = this.buildLoginAuthUser(login, context);
            LoginResult r = this.loginUser(authUser);
            switch (r) {
                case USER_UNVERIFIED: {
                    return this.userUnverified((UsernamePasswordAuthUser)authUser).url();
                }
                case USER_LOGGED_IN: {
                    return authUser;
                }
                case WRONG_PASSWORD: 
                case NOT_FOUND: {
                    return this.onLoginUserNotFound(context);
                }
            }
            throw new AuthException("Something in login went wrong");
        }
        return PlayAuthenticate.getResolver().login().url();
    }

    protected String onLoginUserNotFound(Http.Context context) {
        return PlayAuthenticate.getResolver().login().url();
    }

    public static Result handleLogin(Http.Context ctx) {
        return PlayAuthenticate.handleAuthentication(PROVIDER_KEY, ctx, (Object)Case.LOGIN);
    }

    @Override
    public AuthUser getSessionAuthUser(String id, long expires) {
        return new SessionUsernamePasswordAuthUser(this.getKey(), id, expires);
    }

    public static Result handleSignup(Http.Context ctx) {
        return PlayAuthenticate.handleAuthentication(PROVIDER_KEY, ctx, (Object)Case.SIGNUP);
    }

    private S getSignup(Http.Context ctx) {
        Http.Context.current.set(ctx);
        Form filledForm = this.getSignupForm().bindFromRequest(new String[0]);
        return (S)((UsernamePassword)filledForm.get());
    }

    private L getLogin(Http.Context ctx) {
        Http.Context.current.set(ctx);
        Form filledForm = this.getLoginForm().bindFromRequest(new String[0]);
        return (L)((UsernamePassword)filledForm.get());
    }

    protected String getEmailName(US user) {
        String name = null;
        if (user instanceof NameIdentity) {
            name = ((NameIdentity)user).getName();
        }
        return this.getEmailName(((UsernamePasswordAuthUser)user).getEmail(), name);
    }

    protected String getEmailName(String email, String name) {
        return Mailer.getEmailName((String)email, (String)name);
    }

    protected abstract R generateVerificationRecord(US var1);

    protected void sendVerifyEmailMailing(Http.Context ctx, US user) {
        String subject = this.getVerifyEmailMailingSubject(user, ctx);
        R record = this.generateVerificationRecord(user);
        Mailer.Mail.Body body = this.getVerifyEmailMailingBody(record, user, ctx);
        this.sendMail(subject, body, this.getEmailName(user));
    }

    protected Cancellable sendMail(String subject, Mailer.Mail.Body body, String recipient) {
        return this.sendMail(new Mailer.Mail(subject, body, new String[]{recipient}));
    }

    protected Cancellable sendMail(Mailer.Mail mail) {
        return this.mailer.sendMail(mail);
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    protected abstract String getVerifyEmailMailingSubject(US var1, Http.Context var2);

    protected abstract Mailer.Mail.Body getVerifyEmailMailingBody(R var1, US var2, Http.Context var3);

    protected abstract UL buildLoginAuthUser(L var1, Http.Context var2);

    protected abstract UL transformAuthUser(US var1, Http.Context var2);

    protected abstract US buildSignupAuthUser(S var1, Http.Context var2);

    protected abstract LoginResult loginUser(UL var1);

    protected abstract SignupResult signupUser(US var1);

    protected abstract Form<S> getSignupForm();

    protected abstract Form<L> getLoginForm();

    protected abstract Call userExists(UsernamePasswordAuthUser var1);

    protected abstract Call userUnverified(UsernamePasswordAuthUser var1);

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static interface UsernamePassword {
        public String getEmail();

        public String getPassword();
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    protected static enum LoginResult {
        USER_UNVERIFIED,
        USER_LOGGED_IN,
        NOT_FOUND,
        WRONG_PASSWORD;

    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    protected static enum SignupResult {
        USER_EXISTS,
        USER_CREATED_UNVERIFIED,
        USER_CREATED,
        USER_EXISTS_UNVERIFIED;

    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static enum Case {
        SIGNUP,
        LOGIN;

    }
}

