/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.password;

import com.feth.play.module.pa.user.AuthUser;
import com.feth.play.module.pa.user.EmailIdentity;
import org.mindrot.jbcrypt.BCrypt;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class UsernamePasswordAuthUser
extends AuthUser
implements EmailIdentity {
    private static final long serialVersionUID = 1L;
    private final transient String password;
    private final String email;

    public UsernamePasswordAuthUser(String clearPassword, String email) {
        this.password = clearPassword;
        this.email = email;
    }

    @Override
    public String getId() {
        return this.getHashedPassword();
    }

    @Override
    public String getProvider() {
        return "password";
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public String getHashedPassword() {
        return this.createPassword(this.password);
    }

    protected String createPassword(String clearString) {
        return BCrypt.hashpw((String)clearString, (String)BCrypt.gensalt());
    }

    public boolean checkPassword(String hashed, String candidate) {
        if (hashed == null || candidate == null) {
            return false;
        }
        return BCrypt.checkpw((String)candidate, (String)hashed);
    }

    public String getPassword() {
        return this.password;
    }
}

