/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.CountingOutputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.io.fs.IFSSqlJetTransaction;
import org.tmatesoft.svn.core.internal.io.fs.index.FSLogicalAddressingIndex;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LEntry;
import org.tmatesoft.svn.core.internal.io.fs.index.FSP2LProtoIndex;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSOutputStream
extends OutputStream
implements ISVNDeltaConsumer {
    public static final int SVN_DELTA_WINDOW_SIZE = 102400;
    public static final int WRITE_BUFFER_SIZE = 204800;
    private boolean isHeaderWritten;
    private CountingOutputStream myTargetFileOS;
    private File myTargetFile;
    private long myDeltaStart;
    private long myRepSize;
    private long myRepOffset;
    private InputStream mySourceStream;
    private SVNDeltaGenerator myDeltaGenerator;
    private FSRevisionNode myRevNode;
    private MessageDigest myMD5Digest;
    private MessageDigest mySHA1Digest;
    private FSTransactionRoot myTxnRoot;
    private long mySourceOffset;
    private ByteArrayOutputStream myTextBuffer;
    private boolean myIsClosed;
    private boolean myIsCompress;
    private FSWriteLock myTxnLock;

    private FSOutputStream(FSRevisionNode revNode, CountingOutputStream targetFileOS, File targetFile, InputStream source, long deltaStart, long repSize, long repOffset, FSTransactionRoot txnRoot, boolean compress, FSWriteLock txnLock) throws SVNException {
        SVNErrorMessage err;
        this.myTxnRoot = txnRoot;
        this.myTargetFileOS = targetFileOS;
        this.myTargetFile = targetFile;
        this.mySourceStream = source;
        this.myDeltaStart = deltaStart;
        this.myRepSize = repSize;
        this.myRepOffset = repOffset;
        this.isHeaderWritten = false;
        this.myRevNode = revNode;
        this.mySourceOffset = 0L;
        this.myIsClosed = false;
        this.myTxnLock = txnLock;
        this.myDeltaGenerator = new SVNDeltaGenerator(102400);
        this.myTextBuffer = new ByteArrayOutputStream();
        try {
            this.myMD5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)nsae.getLocalizedMessage());
            SVNErrorManager.error(err, nsae, SVNLogType.FSFS);
        }
        try {
            this.mySHA1Digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "SHA1 implementation not found: {0}", (Object)nsae.getLocalizedMessage());
            SVNErrorManager.error(err, nsae, SVNLogType.FSFS);
        }
        this.myIsCompress = compress;
    }

    private void reset(FSRevisionNode revNode, CountingOutputStream targetFileOS, File targetFile, InputStream source, long deltaStart, long repSize, long repOffset, FSTransactionRoot txnRoot, FSWriteLock txnLock) {
        this.myTxnRoot = txnRoot;
        this.myTargetFileOS = targetFileOS;
        this.myTargetFile = targetFile;
        this.mySourceStream = source;
        this.myDeltaStart = deltaStart;
        this.myRepSize = repSize;
        this.myRepOffset = repOffset;
        this.isHeaderWritten = false;
        this.myRevNode = revNode;
        this.mySourceOffset = 0L;
        this.myIsClosed = false;
        this.myMD5Digest.reset();
        this.mySHA1Digest.reset();
        this.myTextBuffer.reset();
        this.myTxnLock = txnLock;
    }

    public static OutputStream createStream(FSRevisionNode revNode, FSTransactionRoot txnRoot, OutputStream dstStream, boolean compress) throws SVNException {
        SVNErrorMessage err;
        if (revNode.getType() != SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Attempted to set textual contents of a *non*-file node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!revNode.getId().isTxn()) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to set textual contents of an immutable node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        OutputStream targetOS = null;
        InputStream sourceStream = null;
        long offset = -1L;
        long deltaStart = -1L;
        FSWriteLock txnLock = null;
        try {
            txnLock = FSWriteLock.getWriteLockForTxn(txnRoot.getTxnID(), txnRoot.getOwner());
            txnLock.lock();
            File targetFile = txnRoot.getWritableTransactionProtoRevFile();
            offset = targetFile.length();
            targetOS = SVNFileUtil.openFileForWriting(targetFile, true);
            CountingOutputStream revWriter = new CountingOutputStream(targetOS, offset);
            FSRepresentation baseRep = revNode.chooseDeltaBase(txnRoot.getOwner());
            sourceStream = FSInputStream.createDeltaStream(new SVNDeltaCombiner(), baseRep, txnRoot.getOwner());
            String header = baseRep != null ? "DELTA " + baseRep.getRevision() + " " + baseRep.getItemIndex() + " " + baseRep.getSize() + "\n" : "DELTA\n";
            revWriter.write(header.getBytes("UTF-8"));
            deltaStart = revWriter.getPosition();
            if (dstStream instanceof FSOutputStream) {
                FSOutputStream fsOS = (FSOutputStream)dstStream;
                fsOS.reset(revNode, revWriter, targetFile, sourceStream, deltaStart, 0L, offset, txnRoot, txnLock);
                return dstStream;
            }
            return new FSOutputStream(revNode, revWriter, targetFile, sourceStream, deltaStart, 0L, offset, txnRoot, compress, txnLock);
        }
        catch (IOException ioe) {
            SVNFileUtil.closeFile(targetOS);
            SVNFileUtil.closeFile(sourceStream);
            txnLock.unlock();
            FSWriteLock.release(txnLock);
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err2, ioe, SVNLogType.FSFS);
        }
        catch (SVNException svne) {
            if (txnLock != null) {
                txnLock.unlock();
                FSWriteLock.release(txnLock);
            }
            SVNFileUtil.closeFile(targetOS);
            SVNFileUtil.closeFile(sourceStream);
            throw svne;
        }
        return null;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.myMD5Digest.update(b, off, len);
        this.mySHA1Digest.update(b, off, len);
        this.myRepSize += (long)len;
        int toWrite = 0;
        while (len > 0) {
            toWrite = len;
            this.myTextBuffer.write(b, off, toWrite);
            if (this.myTextBuffer.size() >= 204800) {
                try {
                    ByteArrayInputStream target = new ByteArrayInputStream(this.myTextBuffer.toByteArray());
                    this.myDeltaGenerator.sendDelta(null, this.mySourceStream, this.mySourceOffset, target, this, false);
                }
                catch (SVNException svne) {
                    throw new IOException(svne.getMessage());
                }
                this.myTextBuffer.reset();
            }
            off += toWrite;
            len -= toWrite;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.myIsClosed) {
            return;
        }
        boolean truncateToSize = false;
        this.myIsClosed = true;
        try {
            ByteArrayInputStream target = new ByteArrayInputStream(this.myTextBuffer.toByteArray());
            this.myDeltaGenerator.sendDelta(null, this.mySourceStream, this.mySourceOffset, target, this, false);
            FSRepresentation rep = new FSRepresentation();
            rep.setItemIndex(this.myRepOffset);
            long offset = this.myTargetFileOS.getPosition();
            rep.setSize(offset - this.myDeltaStart);
            rep.setExpandedSize(this.myRepSize);
            rep.setTxnId(this.myRevNode.getId().getTxnID());
            String uniqueSuffix = this.myTxnRoot.getNewTxnNodeId();
            String uniquifier = rep.getTxnId() + '/' + uniqueSuffix;
            rep.setUniquifier(uniquifier);
            rep.setRevision(-1L);
            rep.setMD5HexDigest(SVNFileUtil.toHexDigest(this.myMD5Digest));
            rep.setSHA1HexDigest(SVNFileUtil.toHexDigest(this.mySHA1Digest));
            FSFS fsfs = this.myTxnRoot.getOwner();
            FSRepresentation oldRep = this.getSharedRepresentation(fsfs, rep, null);
            if (oldRep != null) {
                this.myRevNode.setTextRepresentation(oldRep);
                truncateToSize = true;
            } else {
                if (fsfs.isUseLogAddressing()) {
                    rep.setItemIndex(this.myTxnRoot.allocateItemIndex(this.myRepOffset));
                }
                this.myTargetFileOS.write("ENDREP\n".getBytes("UTF-8"));
                this.myRevNode.setTextRepresentation(rep);
            }
            this.myRevNode.setIsFreshTxnRoot(false);
            fsfs.putTxnRevisionNode(this.myRevNode.getId(), this.myRevNode);
            if (oldRep == null && fsfs.isUseLogAddressing()) {
                int checksum = this.myTargetFileOS.finalizeChecksum();
                FSOutputStream.storeSha1RepMapping(fsfs, this.myRevNode.getTextRepresentation());
                FSP2LEntry entry = new FSP2LEntry(this.myRepOffset, this.myTargetFileOS.getPosition() - this.myRepOffset, FSP2LProtoIndex.ItemType.FILE_REP, checksum, -1L, rep.getItemIndex());
                this.myTxnRoot.storeP2LIndexEntry(entry);
            }
        }
        catch (SVNException svne) {
            throw new IOException(svne.getMessage());
        }
        finally {
            this.closeStreams();
            try {
                if (truncateToSize) {
                    SVNFileUtil.truncate(this.myTargetFile, this.myRepOffset);
                }
            }
            catch (IOException e) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
            }
            try {
                this.myTxnLock.unlock();
            }
            catch (SVNException sVNException) {}
            FSWriteLock.release(this.myTxnLock);
        }
    }

    public void closeStreams() throws IOException {
        SVNFileUtil.closeFile(this.myTargetFileOS);
        SVNFileUtil.closeFile(this.mySourceStream);
    }

    public FSRevisionNode getRevisionNode() {
        return this.myRevNode;
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.mySourceOffset += (long)diffWindow.getSourceViewLength();
        try {
            diffWindow.writeTo(this.myTargetFileOS, !this.isHeaderWritten, this.myIsCompress);
            this.isHeaderWritten = true;
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
    }

    private FSRepresentation getSharedRepresentation(FSFS fsfs, final FSRepresentation representation, Map<String, FSRepresentation> representationsMap) throws SVNException {
        File file;
        SVNFileType fileType;
        IFSRepresentationCacheManager reposCacheManager;
        if (!fsfs.isRepSharingAllowed()) {
            return null;
        }
        FSRepresentation oldRepresentation = null;
        if (representationsMap != null) {
            oldRepresentation = representationsMap.get(representation.getSHA1HexDigest());
        }
        if (oldRepresentation == null && (reposCacheManager = fsfs.getRepositoryCacheManager()) != null) {
            try {
                reposCacheManager.runReadTransaction(new IFSSqlJetTransaction(){

                    @Override
                    public void run() throws SVNException {
                        FSRepresentation oldRep = reposCacheManager.getRepresentationByHash(representation.getSHA1HexDigest());
                        if (oldRep != null) {
                            oldRep.setUniquifier(representation.getUniquifier());
                            oldRep.setMD5HexDigest(representation.getMD5HexDigest());
                        }
                    }
                });
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_CORRUPT || e.getErrorMessage().getErrorCode().getCategory() == 235000) {
                    throw e;
                }
                SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
            }
            if (oldRepresentation != null) {
                this.checkRepresentation(this.myTxnRoot.getOwner(), oldRepresentation, null);
            }
        }
        if (oldRepresentation == null && representation.isTxn() && (fileType = SVNFileType.getType(file = FSOutputStream.pathTxnSha1(fsfs, representation, representation.getTxnId()))) == SVNFileType.FILE) {
            String representationString = SVNFileUtil.readFile(file);
            oldRepresentation = FSRepresentation.parse(representationString);
        }
        if (oldRepresentation == null) {
            return null;
        }
        if (oldRepresentation.getExpandedSize() != representation.getExpandedSize() || representation.getExpandedSize() == 0L && oldRepresentation.getSize() != representation.getSize()) {
            oldRepresentation = null;
        } else {
            oldRepresentation.setMD5HexDigest(representation.getMD5HexDigest());
            oldRepresentation.setUniquifier(representation.getUniquifier());
        }
        return oldRepresentation;
    }

    private void checkRepresentation(FSFS fsfs, FSRepresentation representation, Object hint) throws SVNException {
        if (fsfs.isUseLogAddressing()) {
            FSFile revFile;
            long startRevision = fsfs.getPackedBaseRevision(representation.getRevision());
            if (hint != null) {
                // empty if block
            }
            if ((revFile = null) != null) {
                // empty if block
            }
            revFile = fsfs.getPackOrRevisionFSFile(representation.getRevision());
            hint = revFile;
            long offset = fsfs.lookupOffsetInIndex(revFile, representation.getRevision(), representation.getItemIndex());
            FSP2LEntry entry = this.lookupP2LEntry(revFile, representation.getRevision(), offset);
            if (entry == null || entry.getType().getCode() < FSP2LProtoIndex.ItemType.FILE_REP.getCode() || entry.getType().getCode() > FSP2LProtoIndex.ItemType.DIR_PROPS.getCode()) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "No representation found at offset {0} for item %s in revision {1}", new Long(offset), new Long(representation.getItemIndex()));
                SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            }
        }
    }

    private FSP2LEntry lookupP2LEntry(FSFile revFile, long revision, long offset) throws SVNException {
        boolean isCached = false;
        if (!isCached) {
            FSLogicalAddressingIndex index = new FSLogicalAddressingIndex(this.myTxnRoot.getOwner(), revFile);
            List<FSP2LEntry> entries = index.lookupP2LEntries(revision, offset, offset + 1L);
            return this.lookupEntry(entries, offset, null);
        }
        return null;
    }

    private FSP2LEntry lookupEntry(List<FSP2LEntry> entries, long offset, Object hint) {
        FSP2LEntry entry;
        if (hint != null) {
            // empty if block
        }
        int index = FSLogicalAddressingIndex.searchLowerBound(entries, offset);
        if (hint != null) {
            // empty if block
        }
        return FSLogicalAddressingIndex.compareEntryOffset(entry = entries.get(index), offset) != 0 ? null : entry;
    }

    private static void storeSha1RepMapping(FSFS fsfs, FSRepresentation representation) throws SVNException {
        if (fsfs.isRepSharingAllowed() && representation != null && representation.getSHA1HexDigest() != null) {
            File fileName = FSOutputStream.pathTxnSha1(fsfs, representation, representation.getTxnId());
            String stringRepresentation = representation.getStringRepresentation(fsfs.getDBFormat());
            SVNFileUtil.writeToFile(fileName, stringRepresentation, "UTF-8");
        }
    }

    private static File pathTxnSha1(FSFS fsfs, FSRepresentation representation, String txnId) {
        String checksum = representation.getSHA1HexDigest();
        File transactionDirectory = fsfs.getTransactionDir(txnId);
        return SVNFileUtil.createFilePath(transactionDirectory, checksum);
    }
}

