/**
 * Yobi, Project Hosting SW
 *
 * Copyright 2013 NAVER Corp.
 * http://yobi.io
 *
 * @author kjkmadness
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package playRepository.hooks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand.Type;

public class ReceiveCommandUtil {
    public static Set<String> getRefNamesByCommandType(Collection<ReceiveCommand> commands, Type... types) {
        Set<String> branches = new HashSet<>();
        for (ReceiveCommand command : commands) {
            if (isTypeMatching(command, types)) {
                branches.add(command.getRefName());
            }
        }
        return branches;
    }

    public static boolean isTypeMatching(ReceiveCommand command, Type... types) {
        return ArrayUtils.contains(types, command.getType());
    }

    public static Set<String> getUpdatedBranches(Collection<ReceiveCommand> commands) {
        return getRefNamesByCommandType(commands, Type.UPDATE, Type.UPDATE_NONFASTFORWARD);
    }

    public static Set<String> getDeletedBranches(Collection<ReceiveCommand> commands) {
        return ReceiveCommandUtil.getRefNamesByCommandType(commands, Type.DELETE);
    }

    public static Set<String> getPushedBranches(Collection<ReceiveCommand> commands) {
        return getRefNamesByCommandType(commands, Type.CREATE, Type.UPDATE,
                Type.UPDATE_NONFASTFORWARD);
    }
}
