# Pull Request

By using `Pull Request` you can let the original project members know the code changes you've made and ask them to review the code, and you can discuss the alterations with the members. Also, your code can be merged when the code review is done.

`Pull Request`, however, is only available for projects using a git repository.


Creating pull requests
----------------------

1. Create or modify code in your projects or forked projects.
1. Push the code to a repository in the project.
1. Go to the project.
1. Click the `Pull Request` menu.
1. Click the `New Pull Request` button.
1. Choose a project and a branch of `from`. This means that the branch in the project has modified and created code.
1. Choose a project and a branch of `to`. This means a branch to which the `from` branch is merged.
1. Click the `Send pull request` button.


Conflicts
---------

If modified codes come into conflicts with the original one, you will see guide on pull request page. To solve the conflicts follow the guide.

Although these conflicts are not solved, pull requests can be created. But you have to solve it to merge your code. If you solve the conflicts, the `Accept` button will be enabled.


Code Review
-----------

The original project members can review the code. If the project's share option is public, non-project members can review the code, and they are able to let others give feedback and discuss with others.

1. Go to a pull request you want to review.
1. Click the `Code Review` tab.
1. There are two ways to open a review text box.
    1. Drag mouse cursor on code you want to review and click the `Comment` button.
    1. Click the `Comment` button at the left of a code line you want to review.
1. Write your review and click the 'Add Comment' button.

Also, you can comment without selecting code.

1. Go to a pull request you want to review.
1. Click the `Code Review` tab.
1. Move to the bottom of page then you will see comment box.
1. Write your review and click the `Add Comment` button.


Accept
------

By using `Accept`, you can merge reviewed source codes to the original project repository.

1. Click a request within the `Pull Request` menu.
1. Click the `Accept` button.
