요비 next 브랜치 사용자 중에서 H2 1.4.184를 사용 중인 사용자는 다음과 같은 방법으로 업데이트하지 않으시면 데이터를 손실할 수 있습니다.

## 현재 사용 중인 H2 버전을 확인하는 방법

요비 프로젝트 홈에 있는 build.sbt 파일에 다음 코드가 있다면 1.4.184 버전을 사용하는 중입니다.

```
"com.h2database" % "h2" % "1.4.184",
```

위와 같은 코드가 보이지 않거나, 버전이 1.3.176 이라면 아래 가이드대로 업그레이드하지 않고 바로 소스 코드를 rebase 하거나 pull 하여 업데이트하여 사용하실 수 있습니다.

45e1288 커밋부터 next 브랜치는 H2 1.4.184 버전을 사용해왔는데, cd534d2 버전 이후부터는 H2 1.3.176(안정된 버전) 버전으로 변경했습니다.
따라서 아래 가이드에 따라 데이터 이관 작업을 해주셔야 합니다.

## 1. 먼저, 현재 사용 중인 요비를 멈추고, 데이터베이스를 백업해 두세요.

```
cp yobi.h2.db yobi.h2.db.bak
```

yobi.h2.db 같은 파일을 다른 이름으로 복사해 두시면 됩니다.
무언가 잘못된 것 같은 경우, 그 파일을 다시 사용하여 요비를 띄우시면 됩니다.

## 2. export-import 브랜치로 변경하세요.

원격 저장소에 있는 요비에 export-import 브랜치가 있을 겁니다.
그 브랜치에서 데이터 백업/복구 기능을 제공하고 있습니다.

## 3. 이제 요비를 다시 실행합니다. (!주의! 아직은 다른 사용자가 접근하지 못하게 해주세요.)

사이트 관리자로 로그인하여 사이트 관리 메뉴에 들어가시면 “데이터”라는 메뉴가 있습니다.
거기서 데이터 백업 버튼을 클릭하시고 다운로드가 완료될 때까지 기다리세요.

이때 오직 사이트 관리자만 요비에 접근해서 백업 작업을 해야 합니다.
그렇지 않으면 데이터 무결성이 깨질 수 있습니다.

다른 사용자 접근을 막기 위해, 프록시 서버를 사용 중이라면 해당 서버를 중단하시고 
기존에 사용하던 포트가 아닌 다른 포트로 요비를 실행하시기 바랍니다.

## 4. 백업이 끝났다면 이제 요비를 다시 멈추고 이제 최신 버전의 next 브랜치로 업데이트하세요.

```
git fetch origin
git rebase origin/next
```

이제 원본에 있는 next 브랜치로 rebase 하거나 pull 을 사용하여 현재 사용 중인 요비를 최신 코드로 업데이트합니다.

## 5. 데이터베이스 파일을 삭제하세요.

```
rm yobi.h2.db
```

기존에 사용하던 데이터베이스 파일을 삭제하세요. 그래야 새로 시작하면서 새로운 데이터베이스가 만들어 집니다.

## 6. 이제 요비를 다시 실행합니다. (!주의! 아직도 다른 사용자가 접근하지 못하게 해주세요.)

다시 한번 사이트 관리자로 로그인하여 설정 메뉴에서 “데이터”로 이동합니다. 이제 조금 전 내려받은 백업 데이터를 선택하고 복구 버튼을 클릭합니다.

모든 데이터가 복구되면 자동으로 첫 페이지로 이동하니, 잠시 기다리세요. 
이 작업도 역시 오직 사이트 관리자만 접근 가능한 상태에서 진행해 주셔야 합니다.

## 7. 끝 

무사히 끝났다면 이제 다른 사용자도 요비를 사용할 수 있게 프록시 서버를 켜주시거나 기존에 사용하던 포트 번호로 요비를 다시 실행해 주시면 됩니다.

감사합니다.
