# Using labels

`Label` is for tagging to issues. Labels help you categorize and search issues.

A label has name and color and is included in a category.

One or more labels can be attached to an issue.


Category
--------

A label should be included in a `Category` and `Category` can have one or more labels.

A category has name and a property which is `multiple labels` or `only single label`.

A category, `multiple labels`, means that multiple labels in the category can be attached to an issue.

A category, `only signel label`, means that only one of labels in the category can be attached to an issue.


Setting issue label
-------------------

To create, delete and edit issue labels, you should go to the `Issue Label` page.

There are two ways:

1. Click the `Issue` menu.
1. Click the sawlike button on the left bottom of the page and on the right of the `Label` text.

or

1. Go to a project.
1. Click the sawlike `Project Settings` button on the right of the project page.
1. Click the `Issue Label` tab.

To go to the `Issue Label` page, you should be a project manager.


Creating labels
---------------

To create labels:

1. Go to the `Issue Label` page.
1. Fill out the forms.
1. Click the `Add label` button.
1. You will see the popup. Click the `multiple labels` or `only single label` button.


Editing category
----------------

To edit labels:

1. Go to the `Issue Label` page.
1. Click the `Edit category` button.
1. Edit the name or the category property.
1. Click the `Save` button.


Editing labels
--------------

To edit labels:

1. Go to the `Issue Label` page.
1. Click the `Edit` button.
1. Edit the name, the color and the category.
1. Click the `Save` button.


Deleting labels
---------------

To delete labels:

1. Go to the `Issue Label` page.
1. Click the `Delete` button.
1. In the dialog that opens, click the `Confirm` button.


Attaching labels
----------------

There are two ways to attach labels to issues.

### Attaching labels to an issue

1. Click the `Issue` menu.
1. Click an issue item.
1. Click the label box on the right of the issue page.
1. Choose a label.

### Attaching labels to issues

1. Click the `Issue` menu.
1. Click the checkboxes on the left of the issues.
1. Click the `Attach label` dropdown box.
1. Select a label.
1. The label will be attached to selected issues.


Detaching labels
----------------

There are two ways to delete labels on issues.

### Detaching labels from an issue

1. Click the `Issue` menu.
1. Click an issue item.
1. Click the `X` on the right of the labels in the label box.

### Detaching labels from issues

1. Click the `Issue` menu.
1. Click the checkboxes on the left of the issues.
1. Click the `Detach label` dropdown box.
1. Select a label.
1. The label is detached from selected labels.
